/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.ConnectionImpl;
import org.mobicents.media.server.resource.Channel;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;

public class LocalConnectionImpl
extends ConnectionImpl {
    private LocalConnectionImpl otherConnection;

    public LocalConnectionImpl(Endpoint endpoint, ConnectionFactory factory) throws ResourceUnavailableException {
        super(endpoint, factory);
    }

    public String getLocalDescriptor() {
        return null;
    }

    public String getRemoteDescriptor() {
        return null;
    }

    public void setRemoteDescriptor(String descriptor) throws IOException, ResourceUnavailableException {
    }

    protected void bind() throws ResourceUnavailableException {
        Collection mediaTypes = this.getEndpoint().getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.bind(mediaType);
        }
    }

    public void setOtherParty(Connection other, MediaType mediaType) throws IOException {
        if ((this.stream & mediaType.getMask()) != 0) {
            this.otherConnection = (LocalConnectionImpl)other;
            this.otherConnection.otherConnection = this;
            int k = mediaType.getCode();
            Channel txChannel = this.txChannels[k];
            Channel rxChannel = this.otherConnection.rxChannels[k];
            if (txChannel != null && rxChannel != null) {
                txChannel.connect(rxChannel);
            }
            rxChannel = this.rxChannels[k];
            txChannel = this.otherConnection.txChannels[k];
            if (txChannel != null && rxChannel != null) {
                txChannel.connect(rxChannel);
            }
            this.setMode(this.mode[k], mediaType);
        }
    }

    public void setOtherParty(Connection other) throws IOException {
        this.otherConnection = (LocalConnectionImpl)other;
        this.otherConnection.otherConnection = this;
        Collection types = this.getEndpoint().getMediaTypes();
        for (MediaType mediaType : types) {
            this.setOtherParty(other, mediaType);
        }
    }

    public void close() {
        super.close();
        if (this.otherConnection == null) {
            return;
        }
        Collection types = this.getEndpoint().getMediaTypes();
        for (MediaType media : types) {
            Channel txChannel = this.txChannels[media.getCode()];
            Channel rxChannel = this.otherConnection.rxChannels[media.getCode()];
            if (txChannel != null && rxChannel != null) {
                txChannel.disconnect(rxChannel);
            }
            rxChannel = this.rxChannels[media.getCode()];
            txChannel = this.otherConnection.txChannels[media.getCode()];
            if (txChannel == null || rxChannel == null) continue;
            rxChannel.disconnect(txChannel);
        }
        this.otherConnection.otherConnection = null;
        this.otherConnection = null;
    }

    public long getPacketsReceived(MediaType media) {
        Channel rxChannel = this.rxChannels[media.getCode()];
        return rxChannel != null ? rxChannel.getPacketsTransmitted() : 0L;
    }

    public long getBytesReceived(MediaType media) {
        Channel rxChannel = this.rxChannels[media.getCode()];
        return rxChannel != null ? rxChannel.getBytesTransmitted() : 0L;
    }

    public long getBytesReceived() {
        long res = 0L;
        for (int i = 0; i < this.rxChannels.length; ++i) {
            if (this.rxChannels[i] == null) continue;
            res += this.rxChannels[i].getBytesTransmitted();
        }
        return res;
    }

    public long getPacketsTransmitted(MediaType media) {
        Channel txChannel = this.txChannels[media.getCode()];
        return txChannel != null ? txChannel.getPacketsTransmitted() : 0L;
    }

    public long getBytesTransmitted(MediaType media) {
        Channel txChannel = this.txChannels[media.getCode()];
        return txChannel != null ? txChannel.getBytesTransmitted() : 0L;
    }

    public long getBytesTransmitted() {
        long res = 0L;
        for (int i = 0; i < this.txChannels.length; ++i) {
            if (this.txChannels[i] == null) continue;
            res += this.txChannels[i].getBytesTransmitted();
        }
        return res;
    }

    public String toString() {
        return "Local Connection [" + this.getEndpoint().getLocalName() + ", idx=" + this.getIndex() + "]";
    }

    public void setOtherParty(String media, InetSocketAddress address) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getJitter(MediaType media) {
        return 0.0;
    }

    public double getJitter() {
        return 0.0;
    }
}

