/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.mobicents.media.Format;
import org.mobicents.media.server.BaseEndpointImpl;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.ConnectionImpl;
import org.mobicents.media.server.impl.rtp.ReceiveStream;
import org.mobicents.media.server.impl.rtp.RtpSocketImpl;
import org.mobicents.media.server.impl.rtp.RtpSocketListener;
import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptor;
import org.mobicents.media.server.impl.rtp.sdp.SessionDescriptor;
import org.mobicents.media.server.resource.Channel;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.rtp.AVProfile;
import org.mobicents.media.server.spi.rtp.RtpManager;
import org.mobicents.media.server.spi.rtp.RtpSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpConnectionImpl
extends ConnectionImpl
implements RtpSocketListener {
    private String localDescriptor;
    private String remoteDescriptor;
    private int[][] payloads = new int[2][15];
    private Format[][] formats = new Format[2][15];
    private int channelCount;
    private int[] formatCount = new int[2];
    private RtpSocket[] sockets = new RtpSocket[2];
    private String bindAddress;
    private int prefferedPayload;
    private Format prefferedFormat;

    public RtpConnectionImpl(Endpoint endpoint, ConnectionFactory connectionFactory, RtpManager rtpFactory) throws ResourceUnavailableException {
        super(endpoint, connectionFactory);
        Collection mediaTypes = endpoint.getMediaTypes();
        RtpManager factory = rtpFactory;
        this.bindAddress = factory.getBindAddress();
        for (MediaType mediaType : mediaTypes) {
            int i = mediaType.getCode();
            try {
                this.sockets[i] = factory.getRTPSocket(mediaType);
                ((RtpSocketImpl)this.sockets[i]).setListener(this);
            }
            catch (IOException e) {
                throw new ResourceUnavailableException((Throwable)e);
            }
        }
    }

    @Override
    protected void join(MediaType mediaType) {
        super.join(mediaType);
        int i = mediaType.getCode();
        Format[] rxFormats = new Format[15];
        int rxCount = 0;
        if (this.rxChannels[i] != null) {
            rxCount = this.getExtendedRxFormats(this.rxChannels[i].getInputFormats(), this.sockets[i].getCodecs(), rxFormats);
        }
        Format[] txFormats = new Format[15];
        int txCount = 0;
        if (this.txChannels[i] != null) {
            txCount = this.getExtendedTxFormats(this.txChannels[i].getOutputFormats(), this.sockets[i].getCodecs(), txFormats);
        }
        HashMap<Integer, Format> profile = this.getProfile(this.sockets[i].getAVProfile(), mediaType);
        this.formatCount[i] = this.intersection(rxFormats, rxCount, txFormats, txCount, profile, this.payloads[i], this.formats[i]);
    }

    @Override
    protected void join() {
        Collection<MediaType> mediaTypes = ((BaseEndpointImpl)this.getEndpoint()).getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.join(mediaType);
        }
    }

    @Override
    protected void bind(MediaType mediaType) throws ResourceUnavailableException {
        if ((this.stream & mediaType.getMask()) != 0) {
            try {
                this.sockets[mediaType.getCode()].bind();
            }
            catch (IOException e) {
                throw new ResourceUnavailableException((Throwable)e);
            }
            super.bind(mediaType);
        }
        this.localDescriptor = null;
    }

    protected void bind() throws ResourceUnavailableException {
        Collection<MediaType> mediaTypes = ((BaseEndpointImpl)this.getEndpoint()).getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.bind(mediaType);
        }
    }

    private HashMap<Integer, Format> getProfile(AVProfile avProfile, MediaType mediaType) {
        HashMap<Integer, Format> profile = new HashMap<Integer, Format>();
        switch (mediaType.getCode()) {
            case 0: {
                profile.putAll(avProfile.getAudioFormats());
                break;
            }
            case 1: {
                profile.putAll(avProfile.getVideoFormats());
            }
        }
        return profile;
    }

    private boolean formatPresent(Format[] srcFormat, Format formatToCheck, int count) {
        for (int i = 0; i < count; ++i) {
            Format f = srcFormat[i];
            if (!f.matches(formatToCheck)) continue;
            return true;
        }
        return false;
    }

    private int getExtendedRxFormats(Format[] formats, Collection<Codec> codecs, Format[] extended) {
        int count = 0;
        for (Format fmt : formats) {
            if (this.formatPresent(extended, fmt, count)) continue;
            extended[count++] = fmt;
            if (fmt == Format.ANY) break;
            for (Codec c : codecs) {
                boolean present;
                if (!c.getSupportedOutputFormat().matches(fmt) || (present = this.formatPresent(extended, c.getSupportedInputFormat(), count))) continue;
                extended[count++] = c.getSupportedInputFormat();
            }
        }
        return count;
    }

    private int getExtendedTxFormats(Format[] formats, Collection<Codec> codecs, Format[] extended) {
        int count = 0;
        for (Format fmt : formats) {
            if (this.formatPresent(extended, fmt, count)) continue;
            extended[count++] = fmt;
            if (fmt == Format.ANY) break;
            for (Codec c : codecs) {
                boolean present;
                if (!c.getSupportedInputFormat().matches(fmt) || (present = this.formatPresent(extended, c.getSupportedOutputFormat(), count))) continue;
                extended[count++] = c.getSupportedOutputFormat();
            }
        }
        return count;
    }

    private int intersection(Format[] rxFormats, int rxCount, Format[] txFormats, int txCount, HashMap<Integer, Format> profile, int[] payloads, Format[] formats) {
        Set<Integer> keys = profile.keySet();
        int count = 0;
        for (Integer key : keys) {
            int i;
            Format f = profile.get(key);
            if (f.matches((Format)AVProfile.DTMF)) {
                payloads[count] = key;
                formats[count++] = f;
                continue;
            }
            boolean found = rxCount == 0;
            for (i = 0; i < rxCount; ++i) {
                if (!f.matches(rxFormats[i])) continue;
                found = true;
            }
            if (!found) continue;
            found = txCount == 0;
            for (i = 0; i < txCount; ++i) {
                if (!f.matches(txFormats[i])) continue;
                found = true;
            }
            if (!found) continue;
            payloads[count] = key;
            formats[count++] = f;
        }
        return count;
    }

    private String createLocalDescriptor() {
        String sessionID;
        SessionDescriptor sdp = null;
        String userName = "-";
        String sessionVersion = sessionID = Long.toString(System.currentTimeMillis() & 0xFFFFFFL);
        String networkType = "IN";
        String addressType = "IP4";
        sdp = new SessionDescriptor();
        sdp.createOrigin(userName, sessionID, sessionVersion, networkType, addressType, this.bindAddress);
        sdp.setSession("Mobicents Media Server");
        sdp.createConnection(networkType, addressType, this.bindAddress);
        Collection<MediaType> mediaTypes = ((BaseEndpointImpl)this.getEndpoint()).getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            int i = mediaType.getCode();
            if (this.formatCount[i] <= 0) continue;
            RtpSocket rtpSocket = this.sockets[i];
            int port = rtpSocket.getLocalPort();
            MediaDescriptor md = sdp.addMedia(MediaType.getMediaType((int)i), port);
            for (int k = 0; k < this.formatCount[i]; ++k) {
                md.addFormat(this.payloads[i][k], this.formats[i][k]);
            }
        }
        this.localDescriptor = sdp.toString();
        return this.localDescriptor;
    }

    public String getLocalDescriptor() {
        if (this.getState() == ConnectionState.NULL || this.getState() == ConnectionState.CLOSED) {
            throw new IllegalStateException("State is " + this.getState());
        }
        if (this.localDescriptor == null) {
            this.createLocalDescriptor();
        }
        return this.localDescriptor;
    }

    public String getRemoteDescriptor() {
        return this.remoteDescriptor;
    }

    private InetAddress getAddress(String address) throws UnknownHostException {
        return InetAddress.getByName(address);
    }

    public void setRemoteDescriptor(String descriptor) throws IOException, ResourceUnavailableException {
        this.remoteDescriptor = descriptor;
        if (this.getState() != ConnectionState.HALF_OPEN && this.getState() != ConnectionState.OPEN) {
            throw new IllegalStateException("State is " + this.getState());
        }
        SessionDescriptor sdp = new SessionDescriptor(descriptor);
        InetAddress address = this.getAddress(sdp.getConnection().getAddress());
        Collection<MediaType> mediaTypes = ((BaseEndpointImpl)this.getEndpoint()).getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.subset(sdp.getMediaDescriptor(mediaType.getCode()), mediaType.getCode());
        }
        boolean negotiated = this.check(sdp);
        if (!negotiated) {
            throw new IOException("Codecs are not negotiated");
        }
        int count = sdp.getMediaTypeCount();
        for (int i = 0; i < count; ++i) {
            MediaDescriptor md = sdp.getMediaDescriptor(i);
            MediaType mediaType = md.getMediaType();
            if ((this.stream & mediaType.getMask()) == 0) continue;
            int k = mediaType.getCode();
            this.selectPreffered(md);
            this.sockets[k].setPeer(address, md.getPort());
            Channel rxChannel = this.rxChannels[k];
            Channel txChannel = this.txChannels[k];
            if (rxChannel != null) {
                rxChannel.connect(this.sockets[k].getReceiveStream());
            }
            if (txChannel != null) {
                txChannel.connect(this.sockets[k].getSendStream());
            }
            this.sockets[k].getReceiveStream().start();
            this.sockets[k].getSendStream().start();
            this.setMode(this.mode[k], mediaType);
        }
        this.localDescriptor = null;
        this.setState(ConnectionState.OPEN);
    }

    private boolean check(SessionDescriptor sdp) {
        int count = sdp.getMediaTypeCount();
        boolean passed = true;
        for (int i = 0; i < count; ++i) {
            MediaDescriptor md = sdp.getMediaDescriptor(i);
            boolean bl = passed = this.formatCount[md.getMediaType().getCode()] != 0;
            if (!passed) break;
        }
        return passed;
    }

    private void subset(MediaDescriptor md, int mediaType) {
        if (md == null) {
            this.formatCount[mediaType] = 0;
            return;
        }
        int[] pt = new int[15];
        Format[] subset = new Format[15];
        int fcount = md.getFormatCount();
        int l = 0;
        boolean mediaFound = false;
        boolean rfc2833Found = false;
        for (int i = 0; i < fcount; ++i) {
            int k;
            Format f = md.getFormat(i);
            if (!rfc2833Found && f.matches((Format)AVProfile.DTMF)) {
                for (k = 0; k < this.formatCount[mediaType]; ++k) {
                    if (!this.formats[mediaType][k].matches(f)) continue;
                    pt[l] = md.getPyaloadType(i);
                    subset[l++] = f;
                    rfc2833Found = true;
                }
            } else if (!mediaFound) {
                for (k = 0; k < this.formatCount[mediaType]; ++k) {
                    if (!this.formats[mediaType][k].matches(f)) continue;
                    pt[l] = md.getPyaloadType(i);
                    subset[l++] = f;
                    mediaFound = true;
                }
            }
            if (mediaFound && rfc2833Found) break;
        }
        this.payloads[mediaType] = pt;
        this.formats[mediaType] = subset;
        this.formatCount[mediaType] = l;
    }

    private void selectPreffered(MediaDescriptor md) {
        int k = md.getMediaType().getCode();
        if (this.formats[k][0].matches((Format)AVProfile.DTMF)) {
            this.sockets[k].setFormat(this.payloads[k][1], this.formats[k][1]);
            this.sockets[k].setDtmfPayload(this.payloads[k][0]);
        } else {
            this.sockets[k].setFormat(this.payloads[k][0], this.formats[k][0]);
            this.sockets[k].setDtmfPayload(this.payloads[k][1]);
        }
    }

    public void setOtherParty(Connection other) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setOtherParty(Connection other, MediaType mediaType) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close(MediaType mediaType) {
        if ((this.stream & mediaType.getMask()) != 0) {
            int i = mediaType.getCode();
            this.formatCount[i] = 0;
            if (this.sockets[i] != null) {
                this.sockets[i].getReceiveStream().stop();
                this.sockets[i].getSendStream().stop();
                if (this.rxChannels[i] != null && this.sockets[i].getReceiveStream().isConnected()) {
                    this.rxChannels[i].disconnect(this.sockets[i].getReceiveStream());
                }
                if (this.txChannels[i] != null && this.sockets[i].getSendStream().isConnected()) {
                    this.txChannels[i].disconnect(this.sockets[i].getSendStream());
                }
                this.sockets[i].release();
                super.close(mediaType);
            }
        }
    }

    @Override
    public void close() {
        Collection<MediaType> mediaTypes = ((BaseEndpointImpl)this.getEndpoint()).getMediaTypes();
        for (MediaType mediaType : mediaTypes) {
            this.close(mediaType);
        }
    }

    @Override
    public void error(Exception e) {
        for (Object ocl : this.connectionListeners.keySet()) {
            ConnectionListener cl = (ConnectionListener)ocl;
            cl.onError((Connection)this, e);
        }
    }

    public long getPacketsReceived(MediaType media) {
        return this.sockets[media.getCode()].getReceiveStream().getPacketsTransmitted();
    }

    public long getBytesReceived(MediaType media) {
        return this.sockets[media.getCode()].getReceiveStream().getBytesTransmitted();
    }

    public long getBytesReceived() {
        int res = 0;
        for (int i = 0; i < this.sockets.length; ++i) {
            if (this.sockets[i] == null) continue;
            res = (int)((long)res + this.sockets[i].getBytesReceived());
        }
        return res;
    }

    public long getPacketsTransmitted(MediaType media) {
        return this.sockets[media.getCode()].getSendStream().getPacketsReceived();
    }

    public long getBytesTransmitted(MediaType media) {
        return this.sockets[media.getCode()].getSendStream().getBytesReceived();
    }

    public long getBytesTransmitted() {
        int res = 0;
        for (int i = 0; i < this.sockets.length; ++i) {
            if (this.sockets[i] == null) continue;
            res = (int)((long)res + this.sockets[i].getBytesReceived());
        }
        return res;
    }

    public double getJitter(MediaType media) {
        return this.sockets[media.getCode()].getJitter();
    }

    public double getJitter() {
        double res = 0.0;
        int count = 0;
        for (int i = 0; i < this.sockets.length; ++i) {
            if (this.sockets[i] == null) continue;
            res += ((ReceiveStream)this.sockets[i].getReceiveStream()).getInterArrivalJitter();
            ++count;
        }
        return res / (double)count;
    }

    public void setOtherParty(String media, InetSocketAddress address) throws IOException {
    }

    public String toString() {
        return "RTP Connection [" + this.getEndpoint().getLocalName() + ", idx=" + this.getIndex() + "], state=" + this.getState();
    }
}

