/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.Outlet;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.FailureEventImpl;
import org.mobicents.media.server.impl.NotifyEventImpl;
import org.mobicents.media.server.spi.events.NotifyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSink
extends BaseComponent
implements MediaSink {
    protected transient MediaSource otherParty;
    private volatile boolean started = false;
    private long packetsReceived;
    private long bytesReceived;
    private NotifyEvent evtStarted;
    private NotifyEvent evtStopped;
    protected Logger logger;
    private ReentrantLock state = new ReentrantLock();

    public AbstractSink(String name) {
        super(name);
        this.logger = Logger.getLogger(this.getClass());
        this.evtStarted = new NotifyEventImpl(this, 10000, "Started");
        this.evtStopped = new NotifyEventImpl(this, 30000, "Stoped");
    }

    public Format getPreffered(Collection<Format> set) {
        if (set != null) {
            this.format = this.selectPreffered(set);
            return this.format;
        }
        this.format = null;
        return null;
    }

    public void assignPreffered(Format format) {
        if (this.otherParty != null) {
            ((AbstractSource)this.otherParty).setPreffered(format);
        }
    }

    protected Format selectPreffered(Collection<Format> set) {
        return set != null ? set.iterator().next() : null;
    }

    public boolean isMultipleConnectionsAllowed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MediaSource otherParty) {
        this.state.lock();
        try {
            if (otherParty == null) {
                throw new IllegalArgumentException("Other party can not be null");
            }
            if (!(otherParty instanceof AbstractSource)) {
                throw new IllegalArgumentException("Can not connect: " + otherParty + " does not extends AbstractSource");
            }
            if (otherParty.isMultipleConnectionsAllowed()) {
                otherParty.connect((MediaSink)this);
                return;
            }
            AbstractSource source = (AbstractSource)otherParty;
            Collection<Format> subset = this.subset(this.getFormats(), otherParty.getFormats());
            if (subset.isEmpty()) {
                throw new IllegalArgumentException("Format missmatch");
            }
            Format preffred = this.getPreffered(subset);
            if (preffred != null) {
                this.format = preffred;
                source.setPreffered(preffred);
            }
            source.otherParty = this;
            this.otherParty = source;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " is connected to " + otherParty));
            }
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MediaSource otherParty) {
        this.state.lock();
        try {
            if (otherParty == null) {
                throw new IllegalArgumentException("Other party can not be null");
            }
            if (!(otherParty instanceof AbstractSource)) {
                throw new IllegalArgumentException("Can not disconnect: " + otherParty + " is not connected");
            }
            if (otherParty.isMultipleConnectionsAllowed()) {
                otherParty.disconnect((MediaSink)this);
                return;
            }
            if (otherParty != this.otherParty) {
                throw new IllegalArgumentException("Can not disconnect: " + otherParty + " is not connected");
            }
            AbstractSource source = (AbstractSource)otherParty;
            source.otherParty = null;
            this.otherParty = null;
            this.getPreffered(null);
            source.setPreffered(null);
        }
        finally {
            this.state.unlock();
        }
    }

    public void connect(Outlet outlet) {
        this.connect(outlet.getOutput());
    }

    public void disconnect(Outlet outlet) {
        this.disconnect(outlet.getOutput());
    }

    public boolean isConnected() {
        return this.otherParty != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract void onMediaTransfer(Buffer var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.state.lock();
        try {
            this.started = true;
            this.resetStats();
            if (this.otherParty != null && !this.otherParty.isStarted()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this + " starting " + this.otherParty + ", started=" + this.otherParty.isStarted()));
                }
                this.otherParty.start();
            }
            this.started();
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.state.lock();
        try {
            this.started = false;
            if (this.otherParty != null && this.otherParty.isStarted()) {
                this.otherParty.stop();
            }
            this.stopped();
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Buffer buffer) throws IOException {
        if (this.isStarted()) {
            try {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(this + " arrive " + buffer + " from " + this.otherParty));
                }
                this.onMediaTransfer(buffer);
                ++this.packetsReceived;
                this.bytesReceived += (long)buffer.getLength();
            }
            catch (Exception e) {
                this.failed(10003, e);
                e.printStackTrace();
            }
            finally {
                buffer.dispose();
            }
        } else {
            this.logger.warn((Object)(this + " is not started"));
        }
    }

    protected void failed(int eventID, Exception e) {
        FailureEventImpl failed = new FailureEventImpl((BaseComponent)this, eventID, e);
        this.sendEvent(failed);
    }

    public long getPacketsReceived() {
        return this.packetsReceived;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public void resetStats() {
        this.packetsReceived = 0L;
        this.bytesReceived = 0L;
    }

    protected void started() {
        this.sendEvent(this.evtStarted);
    }

    protected void stopped() {
        this.sendEvent(this.evtStopped);
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        return null;
    }
}

