/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.util.id.UID;
import org.mobicents.media.Component;
import org.mobicents.media.Format;
import org.mobicents.media.server.ConnectionImpl;
import org.mobicents.media.server.Utils;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.events.NotifyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseComponent
implements Component {
    private static final int LISTENER_TAB_SIZE = 70;
    private String id = null;
    private String name = null;
    private Endpoint endpoint;
    private Connection connection;
    protected Format format;
    private final NotificationListener[] listeners = new NotificationListener[70];

    public BaseComponent(String name) {
        this.name = name;
        this.id = new UID().toString();
    }

    public Format getFormat() {
        return this.format;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        if (this.connection != null && connection == null) {
            for (int index = 0; index < this.listeners.length; ++index) {
                this.listeners[index] = null;
            }
        }
        this.connection = connection;
    }

    protected void sendEvent(NotifyEvent evt) {
        for (NotificationListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                listener.update(evt);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void addListener(NotificationListener listener) {
        Utils.addObject((Object[])this.listeners, (Object)listener);
    }

    public void removeListener(NotificationListener listener) {
        Utils.removeObject((Object[])this.listeners, (Object)listener);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        buffer.append(" (endpoint=");
        if (this.getEndpoint() != null) {
            buffer.append(this.getEndpoint().getLocalName());
        } else {
            buffer.append("unknown");
        }
        if (this.getConnection() != null) {
            buffer.append(", connection=");
            buffer.append(((ConnectionImpl)this.getConnection()).getIndex());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void resetStats() {
    }

    protected Collection<Format> subset(Format[] set1, Format[] set2) {
        ArrayList<Format> subset = new ArrayList<Format>();
        for (int i = 0; i < set1.length; ++i) {
            for (int j = 0; j < set2.length; ++j) {
                if (!set1[i].matches(set2[j])) continue;
                String e1 = set1[i].getEncoding();
                String e2 = set2[j].getEncoding();
                if (!e1.equalsIgnoreCase("ANY")) {
                    subset.add(set1[i]);
                    continue;
                }
                if (!e2.equalsIgnoreCase("ANY")) {
                    subset.add(set2[j]);
                    continue;
                }
                if (!e1.equalsIgnoreCase("ANY") || !e2.equalsIgnoreCase("ANY") || subset.contains(Format.ANY)) continue;
                subset.add(set2[j]);
            }
        }
        return subset;
    }

    public <T> T getInterface(Class<T> interfaceType) {
        return null;
    }
}

