/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.clock;

import org.mobicents.media.server.impl.clock.LocalTask;
import org.mobicents.media.server.impl.clock.TimerImpl;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.Timer;

public class Scheduler
implements Runnable {
    private volatile boolean started = false;
    private Thread worker;
    private long delay;
    private Taskset[] timeline = new Taskset[1000];
    private boolean blocked = false;
    private long second;
    private Timer timer = new TimerImpl();

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void start() {
        this.started = true;
        for (int i = 0; i < 1000; ++i) {
            this.timeline[i] = new Taskset();
        }
        this.worker = new Thread((Runnable)this, "Scheduler");
        this.worker.setPriority(10);
        this.worker.start();
    }

    public void stop() {
        this.started = false;
        this.worker.interrupt();
    }

    public LocalTask execute(Task task) {
        LocalTask localTask;
        ((Taskset)this.timeline[0]).tasks[((Taskset)this.timeline[0]).pos++] = localTask = new LocalTask(task);
        if (this.blocked) {
            this.blocked = false;
        }
        return localTask;
    }

    public void run() {
        int time = 0;
        long start = 0L;
        long finish = 0L;
        long drift = 0L;
        long latency = 0L;
        int duration = 0;
        boolean found = false;
        LocalTask task = null;
        while (this.started) {
            int i;
            Taskset set = this.timeline[time];
            Taskset temp = new Taskset();
            start = this.timer.getTimestamp();
            for (i = 0; i < set.pos; ++i) {
                task = set.tasks[i];
                if (!task.isActive()) continue;
                if (task.seconds > 0L && task.seconds > this.second) {
                    ((Taskset)temp).tasks[((Taskset)temp).pos++] = task;
                    continue;
                }
                duration = 0;
                int count = 0;
                while (duration == 0 && count < 10) {
                    try {
                        duration = task.perform();
                        ++count;
                    }
                    catch (Exception e) {}
                }
                if (duration <= 0) continue;
                int future = time + duration;
                int milliseconds = future % 1000;
                task.seconds = this.second + (long)(future / 1000);
                if (milliseconds == time) {
                    ((Taskset)temp).tasks[((Taskset)temp).pos++] = task;
                    continue;
                }
                ((Taskset)this.timeline[milliseconds]).tasks[((Taskset)this.timeline[milliseconds]).pos++] = task;
            }
            this.timeline[time] = temp;
            found = false;
            for (i = time + 1; i < 1000; ++i) {
                if (this.timeline[i].pos <= 0) continue;
                this.delay = i - time;
                found = true;
                break;
            }
            if (!found) {
                this.delay = 1000 - time;
                ++this.second;
            }
            if ((latency = this.delay - (drift = (finish = this.timer.getTimestamp()) - start)) >= 5L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(latency);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if ((time = (int)((long)time + this.delay)) < 1000) continue;
            time -= 1000;
        }
    }

    public long getTimestamp() {
        return this.timer.getTimestamp();
    }

    private class Taskset {
        private LocalTask[] tasks = new LocalTask[900];
        private int pos = 0;

        private Taskset() {
        }
    }
}

