/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp;

import java.io.IOException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.spi.dsp.Attenuator;
import org.mobicents.media.server.spi.dsp.SignalingProcessor;

public class AttenuatorImpl
extends BaseComponent
implements SignalingProcessor,
Attenuator {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private static final Format[] FORMATS = new Format[]{LINEAR_AUDIO};
    private Input input;
    private Output output;
    private long timestamp;
    private Buffer buff;
    private int volume = 0;
    private double factor = 1.0;

    public AttenuatorImpl(String name) {
        super(name);
        this.input = new Input(name);
        this.output = new Output(name);
    }

    public void setVolume(int volume) {
        this.volume = volume;
        if (this.volume > 0) {
            throw new IllegalArgumentException("Attenuator volume cannot be greater than zero");
        }
        this.factor = Math.pow(10.0, (double)this.volume / 10.0);
    }

    public int getVolume() {
        return this.volume;
    }

    public void connect(MediaSource source) {
        this.input.connect(source);
    }

    public void disconnect(MediaSource source) {
        this.input.disconnect(source);
    }

    public MediaSink getInput() {
        return this.input;
    }

    public void connect(MediaSink sink) {
        this.output.connect(sink);
    }

    public void disconnect(MediaSink sink) {
        this.output.disconnect(sink);
    }

    public MediaSource getOutput() {
        return this.output;
    }

    public void start() {
        if (!this.input.isStarted()) {
            this.input.start();
        }
    }

    private class Output
    extends AbstractSource {
        private volatile boolean started;

        public Output(String name) {
            super(name + ".output");
            this.started = false;
        }

        public void evolve(Buffer buffer, long timestamp) {
            buffer.copy(AttenuatorImpl.this.buff);
        }

        public Format[] getFormats() {
            return FORMATS;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void start() {
            this.started = true;
            if (!AttenuatorImpl.this.input.isStarted()) {
                AttenuatorImpl.this.input.start();
            }
            super.start();
        }

        public void stop() {
            this.started = false;
            if (AttenuatorImpl.this.input.isStarted()) {
                AttenuatorImpl.this.input.stop();
            }
            super.stop();
        }

        protected void transmit(Buffer buffer) {
            if (!this.started) {
                buffer.dispose();
                return;
            }
            if (this.otherParty == null) {
                buffer.dispose();
                return;
            }
            AttenuatorImpl.this.buff = buffer;
            byte[] data = AttenuatorImpl.this.buff.getData();
            for (int i = 0; i < AttenuatorImpl.this.buff.getLength(); i += 2) {
                short s = (short)(data[i] & 0xFF | data[i + 1] << 8);
                s = (short)((double)s * AttenuatorImpl.this.factor);
                data[i] = (byte)s;
                data[i + 1] = (byte)(s >> 8);
            }
            this.perform();
        }

        public String toString() {
            return "Attenuator.Output[" + this.getName() + "]";
        }
    }

    private class Input
    extends AbstractSink {
        private volatile boolean started;

        public Input(String name) {
            super(name + ".input");
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void start() {
            this.started = true;
            if (!AttenuatorImpl.this.output.isStarted()) {
                AttenuatorImpl.this.output.start();
            }
        }

        public void stop() {
            this.started = false;
            if (AttenuatorImpl.this.output.isStarted()) {
                AttenuatorImpl.this.output.stop();
            }
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
            AttenuatorImpl.this.timestamp = buffer.getTimeStamp();
            AttenuatorImpl.this.output.transmit(buffer);
        }

        public long getTimestamp() {
            return AttenuatorImpl.this.timestamp;
        }

        public Format[] getFormats() {
            return FORMATS;
        }

        public String toString() {
            return "Attenuator.Input[" + this.getName() + "]";
        }
    }
}

