/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp;

import java.util.List;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.spi.dsp.Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCodec
implements Codec {
    private List<Codec> sequence;
    private int index;

    public CompositeCodec(List<Codec> sequence) {
        this.sequence = sequence;
    }

    public Format getSupportedInputFormat() {
        return this.sequence.get(0).getSupportedInputFormat();
    }

    public Format getSupportedOutputFormat() {
        return this.sequence.get(this.sequence.size() - 1).getSupportedOutputFormat();
    }

    public void process(Buffer buffer) {
        this.sequence.get(this.index).process(buffer);
        if (buffer.getFlags() == 512) {
            this.index = this.index == this.sequence.size() - 1 ? 0 : this.index + 1;
        }
    }
}

