/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g711.alaw;

import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.SignalingProcessor;

public class Encoder
implements Codec {
    private static final int cClip = 32635;
    private static byte[] aLawCompressTable = new byte[]{1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private SignalingProcessor dsp;

    public void setProc(SignalingProcessor dsp) {
        this.dsp = dsp;
    }

    public Format getSupportedInputFormat() {
        return Codec.LINEAR_AUDIO;
    }

    public Format getSupportedOutputFormat() {
        return Codec.PCMA;
    }

    public void process(Buffer buffer) {
        byte[] data = buffer.getData();
        byte[] res = new byte[data.length / 2];
        this.process(data, 0, data.length, res);
        buffer.setData(res);
        buffer.setOffset(0);
        buffer.setLength(res.length);
        buffer.setFormat((Format)PCMA);
    }

    private int process(byte[] src, int offset, int len, byte[] res) {
        int j = offset;
        int count = len / 2;
        short sample = 0;
        for (int i = 0; i < count; ++i) {
            sample = (short)(src[j++] & 0xFF | src[j++] << 8);
            res[i] = this.linearToALawSample(sample);
        }
        return count;
    }

    private byte[] process(byte[] media) {
        byte[] compressed = new byte[media.length / 2];
        int j = 0;
        for (int i = 0; i < compressed.length; ++i) {
            short sample = (short)(media[j++] & 0xFF | media[j++] << 8);
            compressed[i] = this.linearToALawSample(sample);
        }
        return compressed;
    }

    private byte linearToALawSample(short sample) {
        int s;
        int sign = ~sample >> 8 & 0x80;
        if (sign != 128) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = (short)32635;
        }
        if (sample >= 256) {
            byte exponent = aLawCompressTable[sample >> 8 & 0x7F];
            int mantissa = sample >> exponent + 3 & 0xF;
            s = exponent << 4 | mantissa;
        } else {
            s = sample >> 4;
        }
        return (byte)(s ^= sign ^ 0x55);
    }
}

