/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.dsp.audio.g729.Bits;
import org.mobicents.media.server.impl.dsp.audio.g729.CircularBuffer;
import org.mobicents.media.server.impl.dsp.audio.g729.CodLD8K;
import org.mobicents.media.server.impl.dsp.audio.g729.PreProc;
import org.mobicents.media.server.impl.dsp.audio.g729.Util;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.SignalingProcessor;

public class Encoder
implements Codec {
    int frame = 0;
    CodLD8K encoder = new CodLD8K();
    PreProc preProc = new PreProc();
    CircularBuffer circularBuffer = new CircularBuffer(32000);
    int[] prm = new int[11];
    short[] serial = new short[82];
    private transient Logger logger = Logger.getLogger(Encoder.class);
    FileInputStream testData = null;
    FileOutputStream outdbg = null;

    public Encoder() {
        this.preProc.init_pre_process();
        this.encoder.init_coder_ld8k();
    }

    public Format getSupportedInputFormat() {
        return Codec.LINEAR_AUDIO;
    }

    public Format getSupportedOutputFormat() {
        return Codec.G729;
    }

    public void process(Buffer buffer) {
        byte[] data = buffer.getData();
        this.circularBuffer.addData(data);
        int frameSize = 160;
        byte[] speechWindow = this.circularBuffer.getData(2 * frameSize);
        byte[] resultingBytes = null;
        if (speechWindow == null) {
            resultingBytes = new byte[]{};
        } else {
            int q;
            byte[] one = new byte[frameSize];
            byte[] two = new byte[frameSize];
            for (q = 0; q < frameSize; ++q) {
                one[q] = speechWindow[q];
                two[q] = speechWindow[q + frameSize];
            }
            if ((one = this.process(one)).length != (two = this.process(two)).length) {
                throw new RuntimeException("The two frames are not equal in size!");
            }
            resultingBytes = new byte[one.length + two.length];
            for (q = 0; q < one.length; ++q) {
                resultingBytes[q] = one[q];
                resultingBytes[q + one.length] = two[q];
            }
        }
        buffer.setData(resultingBytes);
        buffer.setOffset(0);
        buffer.setLength(resultingBytes.length);
        buffer.setFormat((Format)Codec.G729);
    }

    public byte[] process(byte[] media) {
        ++this.frame;
        float[] new_speech = new float[media.length];
        short[] shortMedia = Util.byteArrayToShortArray(media);
        for (int i = 0; i < 80; ++i) {
            new_speech[i] = shortMedia[i];
        }
        this.preProc.pre_process(new_speech, 80);
        this.encoder.loadSpeech(new_speech);
        this.encoder.coder_ld8k(this.prm, 0);
        Bits.prm2bits_ld8k(this.prm, this.serial);
        return Bits.toRealBits(this.serial);
    }

    public void processTestDecoderWithFileITUEncoded(Buffer buffer) {
    }

    public void processTestFileWithoutDecoding(Buffer buffer) {
        byte[] res = null;
        try {
            int q;
            byte[] data = new byte[20];
            byte[] tmp = new byte[164];
            this.testData.read(tmp);
            short[] sdata = Util.byteArrayToShortArray(tmp);
            byte[] bits = Bits.toRealBits(sdata);
            for (q = 0; q < 10; ++q) {
                data[q] = bits[q];
            }
            this.testData.read(tmp);
            sdata = Util.byteArrayToShortArray(tmp);
            bits = Bits.toRealBits(sdata);
            for (q = 0; q < 10; ++q) {
                data[10 + q] = bits[q];
            }
            res = data;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setProc(SignalingProcessor processor) {
    }
}

