/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.speex;

import java.io.StreamCorruptedException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.spi.dsp.Codec;
import org.xiph.speex.SpeexDecoder;

public class Decoder
implements Codec {
    private static final int MODE_NB = 0;
    private static final boolean ENHANCED = false;
    private static final int SAMPLE_RATE = 8000;
    private static final int CHANNELS = 1;
    private SpeexDecoder decoder = new SpeexDecoder();

    public Decoder() {
        this.decoder.init(0, 8000, 1, false);
    }

    public Format getSupportedInputFormat() {
        return Codec.SPEEX;
    }

    public Format getSupportedOutputFormat() {
        return Codec.LINEAR_AUDIO;
    }

    public void process(Buffer buffer) {
        byte[] data = buffer.getData();
        byte[] temp = new byte[320];
        int len = this.process(data, 0, data.length, temp);
        byte[] res = new byte[len];
        System.arraycopy(temp, 0, res, 0, len);
        buffer.setData(res);
        buffer.setOffset(0);
        buffer.setLength(len);
        buffer.setFormat((Format)Codec.LINEAR_AUDIO);
    }

    private int process(byte[] media, int offset, int len, byte[] res) {
        try {
            this.decoder.processData(media, offset, len);
            int size = this.decoder.getProcessedDataByteSize();
            this.decoder.getProcessedData(res, 0);
            return size;
        }
        catch (StreamCorruptedException e) {
            return 0;
        }
    }
}

