/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.speex;

import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.spi.dsp.Codec;
import org.xiph.speex.SpeexEncoder;

public class Encoder
implements Codec {
    private int MODE_NB = 0;
    private int mode = 0;
    private int QUALITY = 3;
    private int quality = 3;
    private static final int SAMPLE_RATE = 8000;
    private static final int CHANNELS = 1;
    private SpeexEncoder speexEncoder = new SpeexEncoder();

    public Encoder() {
        this.speexEncoder.init(this.MODE_NB, this.QUALITY, 8000, 1);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public Format getSupportedInputFormat() {
        return Codec.LINEAR_AUDIO;
    }

    public Format getSupportedOutputFormat() {
        return Codec.SPEEX;
    }

    public void process(Buffer buffer) {
        byte[] temp = new byte[320];
        byte[] data = buffer.getData();
        System.arraycopy(data, 0, temp, 0, data.length);
        int len = this.process(temp, 0, 320, data);
        temp = new byte[len];
        System.arraycopy(data, 0, temp, 0, len);
        buffer.setData(data);
        buffer.setOffset(0);
        buffer.setLength(len);
        buffer.setFormat((Format)Codec.SPEEX);
    }

    public int process(byte[] media, int offset, int length, byte[] dest) {
        this.speexEncoder.processData(media, offset, length);
        int size = this.speexEncoder.getProcessedDataByteSize();
        this.speexEncoder.getProcessedData(dest, 0);
        return size;
    }
}

