/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.beans.metadata.api.annotations.Uninstall;
import org.mobicents.media.server.impl.naming.NameToken;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointState;
import org.mobicents.media.server.spi.NamingService;
import org.mobicents.media.server.spi.ResourceUnavailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerNamingService
implements NamingService {
    private HashMap<String, Endpoint> endpoints = new HashMap();
    private int endpointCount = 0;
    private static final Logger logger = Logger.getLogger(InnerNamingService.class);

    public void start() {
        logger.info((Object)"Started");
    }

    public void stop() {
        logger.info((Object)"Stopped");
        Collection<Endpoint> list = this.endpoints.values();
        for (Endpoint endpoint : list) {
            endpoint.stop();
            this.endpointCount = 0;
            logger.info((Object)("Stopped endpoint: local name = " + endpoint.getLocalName()));
        }
    }

    @Install
    public void addEndpoint(Endpoint endpoint) throws ResourceUnavailableException {
        this.endpoints.put(endpoint.getLocalName(), endpoint);
        ++this.endpointCount;
    }

    @Uninstall
    public void removeEndpoint(Endpoint endpoint) {
        this.endpoints.remove(endpoint.getLocalName());
        --this.endpointCount;
        logger.info((Object)("Unregistered endpoint: local name " + endpoint.getLocalName()));
    }

    public Endpoint lookup(String endpointName) throws ResourceUnavailableException {
        if (endpointName.endsWith("$")) {
            return this.findAny(endpointName);
        }
        return this.find(endpointName, true);
    }

    public Endpoint lookup(String endpointName, boolean allowInUse) throws ResourceUnavailableException {
        if (endpointName.endsWith("$")) {
            return this.findAny(endpointName);
        }
        return this.find(endpointName, allowInUse);
    }

    public synchronized Endpoint findAny(String name) throws ResourceUnavailableException {
        Endpoint endpt = null;
        String prefix = name.substring(0, name.indexOf("$") - 1);
        String suffix = null;
        if (name.indexOf("$") + 1 > name.length()) {
            suffix = name.substring(name.indexOf("$") + 1, name.length());
        }
        Set<String> keys = this.endpoints.keySet();
        for (String key : keys) {
            if (!key.startsWith(prefix) || !(suffix != null ? key.contains(suffix) && (endpt = this.endpoints.get(key)).getState() == EndpointState.READY : (endpt = this.endpoints.get(key)).getState() == EndpointState.READY)) continue;
            return endpt;
        }
        if (endpt == null || endpt.getState() != EndpointState.READY) {
            throw new ResourceUnavailableException("No Endpoint found for " + name);
        }
        return endpt;
    }

    public synchronized Endpoint find(String name, boolean allowInUse) throws ResourceUnavailableException {
        Endpoint endpt = this.endpoints.get(name);
        if (endpt == null) {
            throw new ResourceUnavailableException("No Endpoint found for " + name);
        }
        if (endpt.getState() == EndpointState.READY && !allowInUse) {
            throw new ResourceUnavailableException("Endpoint " + name + " is in use");
        }
        return endpt;
    }

    protected Collection<String> getNames(Collection<String> prefixes, NameToken token, Iterator<NameToken> tokens) {
        ArrayList<String> list = new ArrayList<String>();
        if (!tokens.hasNext()) {
            while (token.hasMore()) {
                String s = token.next();
                for (String prefix : prefixes) {
                    list.add(prefix + "/" + s);
                }
            }
            return list;
        }
        ArrayList<String> newPrefixes = new ArrayList<String>();
        while (token.hasMore()) {
            String s = token.next();
            for (String prefix : prefixes) {
                newPrefixes.add(prefix + "/" + s);
            }
        }
        return this.getNames(newPrefixes, tokens.next(), tokens);
    }

    public int getEndpointCount() {
        return this.endpointCount;
    }
}

