/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.cnf;

import org.mobicents.media.server.impl.resource.cnf.AudioMixer;

public class AdaptiveAudioMixer
extends AudioMixer {
    private double targetGain = 1.0;
    private double currentGain = 1.0;
    private static double maxStepDown = 0.045454545454545456;
    private static double maxStepUp = 2.5E-4;

    public AdaptiveAudioMixer(String name) {
        super(name);
    }

    public byte[] mix(byte[][] input) {
        int numSamples = this.packetSize >> 1;
        int numChannels = input.length;
        short[][] inputs = new short[input.length][];
        for (int q = 0; q < numChannels; ++q) {
            inputs[q] = this.byteToShortArray(input[q]);
        }
        int[] mixed = new int[numSamples];
        for (int q = 0; q < numSamples; ++q) {
            for (int w = 0; w < input.length; ++w) {
                int n = q;
                mixed[n] = mixed[n] + inputs[w][q];
            }
        }
        int numExceeding = 0;
        int maxExcess = 0;
        for (int q = 0; q < numSamples; ++q) {
            int excess = 0;
            int overflow = mixed[q] - Short.MAX_VALUE;
            int underflow = mixed[q] - Short.MIN_VALUE;
            if (overflow > 0) {
                excess = overflow;
            } else if (underflow < 0) {
                excess = -underflow;
            }
            if (excess > 0) {
                ++numExceeding;
            }
            maxExcess = Math.max(maxExcess, excess);
        }
        this.targetGain = numExceeding > numSamples >> 5 ? (double)(32767.0f / (float)(Short.MAX_VALUE + maxExcess + 2000)) : 1.0;
        byte[] data = new byte[this.packetSize];
        int l = 0;
        for (int q = 0; q < numSamples; ++q) {
            int n = q;
            mixed[n] = (int)((double)mixed[n] * this.currentGain);
            if (this.targetGain - this.currentGain >= maxStepUp) {
                this.currentGain += maxStepUp;
            } else if (this.currentGain - this.targetGain > maxStepDown) {
                this.currentGain -= maxStepDown;
            }
            short s = (short)mixed[q];
            data[l++] = (byte)s;
            data[l++] = (byte)(s >> 8);
        }
        return data;
    }
}

