/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.cnf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSinkSet;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.AbstractSourceSet;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.resource.Proxy;
import org.mobicents.media.server.impl.resource.cnf.AudioMixer;
import org.mobicents.media.server.impl.resource.cnf.Splitter;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceGroup;
import org.mobicents.media.server.spi.dsp.Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConferenceBridge
extends BaseComponent
implements ResourceGroup {
    protected Endpoint endpoint;
    public static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO};
    protected ConcurrentHashMap<String, Splitter> splitters = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, AudioMixer> mixers = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Proxy> proxies = new ConcurrentHashMap();
    private Input input = new Input("CnfBridge(Input)");
    private Output output = new Output("CnfBridge(Output)");
    private static ArrayList<MediaType> mediaTypes = new ArrayList();

    public ConferenceBridge(String name) {
        super(name);
    }

    public Collection<MediaType> getMediaTypes() {
        return mediaTypes;
    }

    public MediaSource getSource(MediaType media) {
        return media == MediaType.AUDIO ? this.output : null;
    }

    public MediaSink getSink(MediaType media) {
        return media == MediaType.AUDIO ? this.input : null;
    }

    public void start() {
    }

    public void stop() {
    }

    static {
        mediaTypes.add(MediaType.AUDIO);
    }

    private class Output
    extends AbstractSourceSet {
        public Output(String name) {
            super(name);
        }

        public void start() {
            Collection<AudioMixer> list = ConferenceBridge.this.mixers.values();
            for (AudioMixer mixer : list) {
                mixer.start();
            }
        }

        public AbstractSource createSource(MediaSink otherParty) {
            AudioMixer mixer = new AudioMixer("AudioMixer[CnfBridge]");
            ConferenceBridge.this.mixers.put(mixer.getOutput().getId(), mixer);
            mixer.setEndpoint(mixer.getEndpoint());
            mixer.setConnection(otherParty.getConnection());
            Collection<Splitter> list = ConferenceBridge.this.splitters.values();
            for (Splitter splitter : list) {
                if (splitter.getConnection().getId().equals(otherParty.getConnection().getId())) continue;
                Proxy proxy = new Proxy("Proxy[CnfBridge]");
                ConferenceBridge.this.proxies.put(mixer.getId(), proxy);
                proxy.getInput().connect((MediaSource)splitter);
                proxy.getOutput().connect((MediaSink)mixer);
                proxy.start();
            }
            return (AbstractSource)mixer.getOutput();
        }

        public void evolve(Buffer buffer, long timestamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Format[] getFormats() {
            return FORMATS;
        }

        public void destroySource(AbstractSource source) {
        }
    }

    private class Input
    extends AbstractSinkSet {
        public Input(String name) {
            super(name);
        }

        public AbstractSink createSink(MediaSource otherParty) {
            Splitter splitter = new Splitter("Splitter[CnfBridge]");
            String id = splitter.getInput().getId();
            splitter.setEndpoint(otherParty.getEndpoint());
            splitter.setConnection(otherParty.getConnection());
            ConferenceBridge.this.splitters.put(id, splitter);
            Collection<AudioMixer> list = ConferenceBridge.this.mixers.values();
            for (AudioMixer mixer : list) {
                if (mixer.getConnection().getId().equals(otherParty.getConnection().getId())) continue;
                Proxy proxy = new Proxy("Proxy[CnfBridge]");
                ConferenceBridge.this.proxies.put(splitter.getId(), proxy);
                proxy.getInput().connect((MediaSource)splitter);
                proxy.getOutput().connect((MediaSink)mixer);
                proxy.start();
            }
            return splitter.getInput();
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Format[] getFormats() {
            return FORMATS;
        }

        public boolean isAcceptable(Format format) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void destroySink(AbstractSink sink) {
        }
    }
}

