/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.cnf;

import org.mobicents.media.server.impl.resource.cnf.AudioMixer;

public class MaxPowerAudioMixer
extends AudioMixer {
    private int lastChannel = 0;
    private static int takeoverRatio = 2;

    public MaxPowerAudioMixer(String name) {
        super(name);
    }

    public byte[] mix(byte[][] input) {
        int q;
        int numChannels = input.length;
        short[][] inputs = new short[input.length][];
        long[] powerPerChannel = new long[numChannels];
        long[] sumPerChannel = new long[numChannels];
        for (int q2 = 0; q2 < numChannels; ++q2) {
            inputs[q2] = this.byteToShortArray(input[q2]);
            for (int w = 0; w < inputs[q2].length; ++w) {
                int n = q2;
                powerPerChannel[n] = powerPerChannel[n] + (long)Math.abs(inputs[q2][w]);
                int n2 = q2;
                sumPerChannel[n2] = sumPerChannel[n2] + (long)inputs[q2][w];
            }
        }
        int maxPowerChannel = 0;
        long maxPower = 0L;
        for (q = 0; q < numChannels; ++q) {
            int n = q;
            powerPerChannel[n] = powerPerChannel[n] - sumPerChannel[q];
        }
        for (q = 0; q < numChannels; ++q) {
            if (powerPerChannel[q] <= maxPower) continue;
            maxPowerChannel = q;
            maxPower = powerPerChannel[q];
        }
        if (maxPower / (long)takeoverRatio < powerPerChannel[this.lastChannel]) {
            maxPowerChannel = this.lastChannel;
        }
        return input[maxPowerChannel];
    }
}

