/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.dtmf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.dsp.audio.g711.alaw.DecoderFactory;
import org.mobicents.media.server.impl.dsp.audio.g729.EncoderFactory;
import org.mobicents.media.server.impl.resource.GoertzelFilter;
import org.mobicents.media.server.impl.resource.dtmf.DtmfBuffer;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEvent;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;
import org.mobicents.media.server.spi.resource.DtmfDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorImpl
extends DtmfBuffer {
    private static final int TONE_DURATION = 50;
    private static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO, Codec.PCMA, Codec.PCMU, Codec.GSM, Codec.SPEEX, Codec.G729};
    public static final String[][] events = new String[][]{{"1", "2", "3", "A"}, {"4", "5", "6", "B"}, {"7", "8", "9", "C"}, {"*", "0", "#", "D"}};
    private static final String[] evtID = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "#", "*"};
    private static final int[] lowFreq = new int[]{697, 770, 852, 941};
    private static final int[] highFreq = new int[]{1209, 1336, 1477, 1633};
    private GoertzelFilter[] lowFreqFilters = new GoertzelFilter[4];
    private GoertzelFilter[] highFreqFilters = new GoertzelFilter[4];
    private double threshold;
    private int level;
    private int offset = 0;
    private int toneDuration = 50;
    private int N = 8 * this.toneDuration;
    private double scale = (double)this.toneDuration / 1000.0;
    private double[] p = new double[4];
    private double[] P = new double[4];
    private double[] signal = new double[this.N];
    private double maxAmpl;
    private Codec codec;
    private static final ArrayList<CodecFactory> codecFactories = new ArrayList();
    private boolean isLazy = false;

    public DetectorImpl(String name) {
        super(name);
        for (int i = 0; i < 4; ++i) {
            this.lowFreqFilters[i] = new GoertzelFilter(lowFreq[i], this.N, this.scale);
            this.highFreqFilters[i] = new GoertzelFilter(highFreq[i], this.N, this.scale);
        }
        this.setVolume(-30);
    }

    private Codec selectCodec(Format f) {
        for (CodecFactory factory : codecFactories) {
            if (!factory.getSupportedInputFormat().matches(f) || !factory.getSupportedOutputFormat().matches((Format)Codec.LINEAR_AUDIO)) continue;
            return factory.getCodec();
        }
        return null;
    }

    @Override
    public Format selectPreffered(Collection<Format> formats) {
        for (Format f : formats) {
            if (!f.matches((Format)Codec.LINEAR_AUDIO)) continue;
            this.codec = null;
            return f;
        }
        for (Format f : formats) {
            if (!f.matches((Format)Codec.PCMA) && !f.matches((Format)Codec.PCMU)) continue;
            this.codec = this.selectCodec(f);
            return f;
        }
        for (Format f : formats) {
            if (!f.matches((Format)Codec.GSM)) continue;
            this.codec = this.selectCodec(f);
            return f;
        }
        return super.selectPreffered(formats);
    }

    public void setDuration(int duartion) {
        this.toneDuration = duartion;
    }

    public int getDuration() {
        return this.toneDuration;
    }

    public void setVolume(int level) {
        this.level = level;
        this.threshold = Math.pow(Math.pow(10.0, level), 0.1) * 32767.0;
    }

    public void setLasy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public int getVolume() {
        return this.level;
    }

    @Override
    public void onMediaTransfer(Buffer buffer) throws IOException {
        if (buffer.getHeader() != null) {
            DtmfEvent evt = (DtmfEvent)buffer.getHeader();
            this.push(evtID[evt.getEventID()]);
            return;
        }
        if (this.isLazy) {
            return;
        }
        if (this.codec != null) {
            this.codec.process(buffer);
        }
        byte[] data = buffer.getData();
        int M = data.length;
        int k = 0;
        while (k < M) {
            while (this.offset < this.N && k < M - 1) {
                int n = k++;
                int n2 = k++;
                double s = data[n] & 0xFF | data[n2] << 8;
                double sa = Math.abs(s);
                if (sa > this.maxAmpl) {
                    this.maxAmpl = sa;
                }
                this.signal[this.offset++] = s;
            }
            if (this.offset != this.N) continue;
            this.offset = 0;
            if (!(this.maxAmpl >= this.threshold)) continue;
            this.maxAmpl = 0.0;
            this.getPower(this.lowFreqFilters, this.signal, 0, this.p);
            this.getPower(this.highFreqFilters, this.signal, 0, this.P);
            String tone = this.getTone(this.p, this.P);
            if (tone == null) continue;
            this.push(tone);
        }
    }

    private void getPower(GoertzelFilter[] filters, double[] data, int offset, double[] power) {
        for (int i = 0; i < 4; ++i) {
            power[i] = filters[i].getPower(data, offset);
        }
    }

    private int getMax(double[] data) {
        int idx = 0;
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(max < data[i])) continue;
            max = data[i];
            idx = i;
        }
        return idx;
    }

    private String getTone(double[] f, double[] F) {
        int fm = this.getMax(f);
        boolean fd = true;
        for (int i = 0; i < f.length; ++i) {
            double r;
            if (fm == i || !((r = f[fm] / (f[i] + 1.0E-15)) < this.threshold)) continue;
            fd = false;
            break;
        }
        if (!fd) {
            return null;
        }
        int Fm = this.getMax(F);
        boolean Fd = true;
        for (int i = 0; i < F.length; ++i) {
            double r;
            if (Fm == i || !((r = F[Fm] / (F[i] + 1.0E-15)) < this.threshold)) continue;
            Fd = false;
            break;
        }
        if (!Fd) {
            return null;
        }
        return events[fm][Fm];
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public boolean isAcceptable(Format format) {
        return format.matches((Format)Codec.LINEAR_AUDIO);
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        if (interfaceType.equals(DtmfDetector.class)) {
            return (T)this;
        }
        return null;
    }

    static {
        codecFactories.add(new DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.alaw.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g711.ulaw.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.gsm.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.gsm.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.speex.DecoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.speex.EncoderFactory());
        codecFactories.add(new org.mobicents.media.server.impl.dsp.audio.g729.DecoderFactory());
        codecFactories.add(new EncoderFactory());
    }
}

