/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.fft;

import java.io.IOException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.resource.fft.Complex;
import org.mobicents.media.server.impl.resource.fft.FFT;
import org.mobicents.media.server.impl.resource.fft.SpectrumEvent;

public class SpectraAnalyzer
extends AbstractSink {
    private static final AudioFormat LINEAR_AUDIO = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private int offset = 0;
    private byte[] localBuffer = new byte[16000];
    private FFT fft = new FFT();

    public SpectraAnalyzer(String name) {
        super(name);
    }

    private double[] mod(Complex[] x) {
        double[] res = new double[x.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Math.sqrt(x[i].re() * x[i].re() + x[i].im() * x[i].im());
        }
        return res;
    }

    protected void sendEvent(double[] spectra) {
        SpectrumEvent evt = new SpectrumEvent((BaseComponent)this, spectra);
        this.sendEvent(evt);
    }

    public void onMediaTransfer(Buffer buffer) throws IOException {
        byte[] data = buffer.getData();
        int len = Math.min(16000 - this.offset, data.length);
        System.arraycopy(data, 0, this.localBuffer, this.offset, len);
        this.offset += len;
        if (this.offset == 16000) {
            double[] media = new double[8000];
            int j = 0;
            for (int i = 0; i < media.length; ++i) {
                media[i] = this.localBuffer[j++] & 0xFF | this.localBuffer[j++] << 8;
            }
            Complex[] signal = new Complex[8192];
            double k = (double)(media.length - 1) / (double)signal.length;
            for (int i = 0; i < signal.length; ++i) {
                int p = (int)(k * (double)i);
                int q = (int)(k * (double)i) + 1;
                double K = (media[q] - media[p]) * (double)media.length;
                double dx = (double)i / (double)signal.length - (double)p / (double)media.length;
                signal[i] = new Complex(media[p] + K * dx, 0.0);
            }
            this.localBuffer = new byte[16000];
            this.offset = 0;
            Complex[] sp = this.fft.fft(signal);
            double[] res = this.mod(sp);
            this.sendEvent(res);
        }
    }

    public boolean isAcceptable(Format fmt) {
        return fmt.matches((Format)LINEAR_AUDIO);
    }

    public Format[] getFormats() {
        return new Format[]{LINEAR_AUDIO};
    }
}

