/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.gsm;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.format.UnsupportedFormatException;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.spi.rtp.AVProfile;

public class GsmTrackImpl
implements Track {
    private static final AudioFormat.Encoding GSM_ENCODING = new AudioFormat.Encoding("GSM0610");
    private transient AudioInputStream stream = null;
    private AudioFormat format;
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private long duration;
    private long timestamp;

    public GsmTrackImpl(URL url) throws UnsupportedAudioFileException, IOException, UnsupportedFormatException {
        this.stream = AudioSystem.getAudioInputStream(url);
        this.format = this.getFormat(this.stream);
        if (this.format == null) {
            throw new UnsupportedFormatException((Format)this.format);
        }
        this.duration = (long)((float)this.stream.getFrameLength() / this.stream.getFormat().getFrameRate() * 1000.0f);
        this.frameSize = 33;
    }

    public void setPeriod(int period) {
        throw new IllegalArgumentException("Period can not be changed");
    }

    public int getPeriod() {
        return this.period;
    }

    private AudioFormat getFormat(AudioInputStream stream) {
        AudioFormat.Encoding encoding = stream.getFormat().getEncoding();
        if (encoding.equals(GSM_ENCODING)) {
            return AVProfile.GSM;
        }
        return null;
    }

    public long getMediaTime() {
        return this.timestamp;
    }

    public void setMediaTime(long timestamp) {
        this.timestamp = timestamp;
        try {
            this.stream.reset();
            long offset = (long)this.frameSize * (timestamp / (long)this.period);
            this.stream.skip(offset);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getDuration() {
        return this.duration;
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length;
        try {
            int len;
            for (length = 0; length < psize; length += len) {
                len = this.stream.read(packet, offset + length, psize - length);
                if (len != -1) continue;
                return length;
            }
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return length;
        }
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = 0;
        }
    }

    public void process(Buffer buffer) throws IOException {
        byte[] data = buffer.getData();
        if (data == null) {
            data = new byte[this.frameSize];
        }
        buffer.setData(data);
        int len = this.readPacket(data, 0, this.frameSize);
        if (len == 0) {
            this.eom = true;
        }
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        buffer.setOffset(0);
        buffer.setLength(this.frameSize);
        buffer.setEOM(this.eom);
        buffer.setDuration((long)this.period);
        this.timestamp += (long)this.period;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Format getFormat() {
        return this.format;
    }
}

