/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.tts;

import com.sun.speech.freetts.Voice;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.mobicents.media.server.impl.resource.mediaplayer.audio.tts.VoiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoicesCache {
    private HashMap<String, LinkedList<Voice>> voicePool = new HashMap();
    private VoiceManager voiceManager = VoiceManager.getInstance();

    public Voice allocateVoice(String voiceName) {
        LinkedList<Object> voicesList = this.voicePool.get(voiceName);
        if (voicesList == null) {
            voicesList = new LinkedList();
            this.voicePool.put(voiceName, voicesList);
        }
        if (voicesList.size() == 0) {
            Voice v = this.voiceManager.getVoice(voiceName);
            v.allocate();
            return v;
        }
        return (Voice)voicesList.removeFirst();
    }

    public void releaseVoice(Voice v) {
        v.setAudioPlayer(null);
        this.voicePool.get(v.getName().toLowerCase()).add(v);
    }

    public void clear() {
        Iterator<Map.Entry<String, LinkedList<Voice>>> it = this.voicePool.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LinkedList<Voice>> entry = it.next();
            it.remove();
            for (Voice v : entry.getValue()) {
                v.deallocate();
            }
            entry.getValue().clear();
        }
    }

    public void init(Map<String, Integer> voices) {
        for (String voiceName : voices.keySet()) {
            LinkedList<Voice> list = new LinkedList<Voice>();
            this.voicePool.put(voiceName, list);
            for (int voiceCount = voices.get(voiceName).intValue(); voiceCount > 0; --voiceCount) {
                Voice v = this.voiceManager.getVoice(voiceName);
                v.allocate();
                list.add(v);
            }
        }
    }
}

