/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.audio.wav;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.format.UnsupportedFormatException;
import org.mobicents.media.server.impl.resource.mediaplayer.Track;
import org.mobicents.media.server.spi.rtp.AVProfile;

public class WavTrackImpl
implements Track {
    private transient AudioInputStream stream = null;
    private AudioFormat format;
    private int period = 20;
    private int frameSize;
    private boolean eom;
    private long timestamp;
    private long duration;

    public WavTrackImpl(URL url) throws UnsupportedAudioFileException, IOException, UnsupportedFormatException {
        this.stream = AudioSystem.getAudioInputStream(url);
        this.duration = (long)((float)this.stream.getFrameLength() / this.stream.getFormat().getFrameRate() * 1000.0f);
        this.format = this.getFormat(this.stream);
        if (this.format == null) {
            throw new UnsupportedFormatException((Format)this.format);
        }
        this.frameSize = (int)((double)(this.period * this.format.getChannels() * this.format.getSampleSizeInBits()) * this.format.getSampleRate() / 8000.0);
    }

    public void setPeriod(int period) {
        this.period = period;
        this.frameSize = (int)((double)(period * this.format.getChannels() * this.format.getSampleSizeInBits()) * this.format.getSampleRate() / 8000.0);
    }

    public int getPeriod() {
        return this.period;
    }

    public long getMediaTime() {
        return this.timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setMediaTime(long timestamp) {
        this.timestamp = timestamp;
        try {
            this.stream.reset();
            long offset = (long)this.frameSize * (timestamp / (long)this.period);
            this.stream.skip(offset);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private AudioFormat getFormat(AudioInputStream stream) {
        AudioFormat.Encoding encoding = stream.getFormat().getEncoding();
        if (encoding == AudioFormat.Encoding.ALAW) {
            return AVProfile.PCMA;
        }
        if (encoding == AudioFormat.Encoding.ULAW) {
            return AVProfile.PCMU;
        }
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            int sampleSize = stream.getFormat().getSampleSizeInBits();
            int sampleRate = (int)stream.getFormat().getSampleRate();
            int channels = stream.getFormat().getChannels();
            return new AudioFormat("LINEAR", (double)sampleRate, sampleSize, channels, 0, 1);
        }
        return null;
    }

    private int readPacket(byte[] packet, int offset, int psize) throws IOException {
        int length;
        try {
            int len;
            for (length = 0; length < psize; length += len) {
                len = this.stream.read(packet, offset + length, psize - length);
                if (len != -1) continue;
                return length;
            }
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return length;
        }
    }

    private void padding(byte[] data, int count) {
        int offset = data.length - count;
        for (int i = 0; i < count; ++i) {
            data[i + offset] = 0;
        }
    }

    public void process(Buffer buffer) throws IOException {
        byte[] data = buffer.getData();
        if (data == null) {
            data = new byte[this.frameSize];
        }
        buffer.setData(data);
        int len = this.readPacket(data, 0, this.frameSize);
        if (len == 0) {
            this.eom = true;
        }
        if (len < this.frameSize) {
            this.padding(data, this.frameSize - len);
            this.eom = true;
        }
        buffer.setOffset(0);
        buffer.setLength(this.frameSize);
        buffer.setEOM(this.eom);
        buffer.setDuration((long)this.period);
        this.timestamp += (long)this.period;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Format getFormat() {
        return this.format;
    }
}

