/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.DataEntryUrlBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.DataEntryUrnBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.FullBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.UndefinedBox;

public class DataReferenceBox
extends FullBox {
    static byte[] TYPE = new byte[]{100, 114, 101, 102};
    static String TYPE_S = "dref";
    private long entryCount;
    private Box[] dataEntry;

    public DataReferenceBox(long size) {
        super(size, TYPE_S);
    }

    protected int load(DataInputStream fin) throws IOException {
        super.load(fin);
        this.entryCount = this.readU32(fin);
        this.dataEntry = new Box[(int)this.entryCount];
        int i = 0;
        while ((long)i < this.entryCount) {
            long len = this.readU32(fin);
            String type = this.readType(fin);
            if (type.equals("url ")) {
                this.dataEntry[i] = new DataEntryUrlBox(len, type);
                this.dataEntry[i].load(fin);
            } else if (type.equals("urn")) {
                this.dataEntry[i] = new DataEntryUrnBox(len, type);
                this.dataEntry[i].load(fin);
            } else {
                this.dataEntry[i] = new UndefinedBox(len, type);
                this.dataEntry[i].load(fin);
            }
            ++i;
        }
        return (int)this.getSize();
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

