/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.FullBox;

public class MovieHeaderBox
extends FullBox {
    static byte[] TYPE = new byte[]{109, 118, 104, 100};
    static String TYPE_S = "mvhd";
    private long creationTime;
    private long modificationTime;
    private long timescale;
    private long duration;
    private double rate;
    private double volume;
    private int[] matrix = new int[9];
    private int[] predefined = new int[6];
    private int nextTrackID;
    private Calendar calendar = Calendar.getInstance();

    public MovieHeaderBox(long size) {
        super(size, TYPE_S);
    }

    public Date getCreationTime() {
        this.calendar.set(1, 1904);
        this.calendar.set(2, 0);
        this.calendar.set(5, 1);
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.roll(13, (int)this.creationTime);
        return this.calendar.getTime();
    }

    public Date getModificationTime() {
        return new Date(this.modificationTime);
    }

    public long getTimeScale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getRate() {
        return this.rate;
    }

    public double getVolume() {
        return this.volume;
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public int getNextTrackID() {
        return this.nextTrackID;
    }

    protected int load(DataInputStream fin) throws IOException {
        int i;
        super.load(fin);
        if (this.getVersion() == 1) {
            this.creationTime = this.readU64(fin);
            this.modificationTime = this.readU64(fin);
            this.timescale = this.readU32(fin);
            this.duration = this.readU64(fin);
        } else {
            this.creationTime = this.readU32(fin);
            this.modificationTime = this.readU32(fin);
            this.timescale = this.readU32(fin);
            this.duration = this.readU32(fin);
        }
        int a = fin.readInt();
        this.rate = (a >> 16) + (a & 0xFFFF) / 10;
        this.volume = fin.readByte() + fin.readByte() / 10;
        fin.readByte();
        fin.readByte();
        fin.readInt();
        fin.readInt();
        for (i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = fin.readInt();
        }
        for (i = 0; i < this.predefined.length; ++i) {
            this.predefined[i] = fin.readInt();
        }
        this.nextTrackID = fin.readInt();
        return (int)this.getSize();
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

