/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.mediaplayer.mpeg;

import java.io.DataInputStream;
import java.io.IOException;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.Box;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.ChunkOffsetBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.CompositionOffsetBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleDescriptionBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleSizeBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SampleToChunkBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.SyncSampleBox;
import org.mobicents.media.server.impl.resource.mediaplayer.mpeg.TimeToSampleBox;

public class SampleTableBox
extends Box {
    static byte[] TYPE = new byte[]{115, 116, 98, 108};
    static String TYPE_S = "stbl";
    private SampleDescriptionBox sampleDescription;
    private TimeToSampleBox timeToSampleBox;
    private CompositionOffsetBox compositionOffsetBox;
    private SampleToChunkBox sampleToChunkBox;
    private SampleSizeBox sampleSizeBox;
    private ChunkOffsetBox chunkOffsetBox;
    private SyncSampleBox syncSampleBox;

    public SampleTableBox(long size) {
        super(size, TYPE_S);
    }

    protected int load(DataInputStream fin) throws IOException {
        int count = 8;
        while ((long)count < this.getSize()) {
            long len = this.readU32(fin);
            byte[] type = this.read(fin);
            if (this.comparebytes(type, SampleDescriptionBox.TYPE)) {
                this.sampleDescription = new SampleDescriptionBox(len);
                count += this.sampleDescription.load(fin);
                continue;
            }
            if (this.comparebytes(type, TimeToSampleBox.TYPE)) {
                this.timeToSampleBox = new TimeToSampleBox(len);
                count += this.timeToSampleBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, CompositionOffsetBox.TYPE)) {
                this.compositionOffsetBox = new CompositionOffsetBox(len);
                count += this.compositionOffsetBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, SampleToChunkBox.TYPE)) {
                this.sampleToChunkBox = new SampleToChunkBox(len);
                count += this.sampleToChunkBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, SampleSizeBox.TYPE)) {
                this.sampleSizeBox = new SampleSizeBox(len);
                count += this.sampleSizeBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, ChunkOffsetBox.TYPE)) {
                this.chunkOffsetBox = new ChunkOffsetBox(len);
                count += this.chunkOffsetBox.load(fin);
                continue;
            }
            if (this.comparebytes(type, SyncSampleBox.TYPE)) {
                this.syncSampleBox = new SyncSampleBox(len);
                count += this.syncSampleBox.load(fin);
                continue;
            }
            throw new IOException("Unknown box=" + new String(type) + " Parent SampleTableBox");
        }
        return (int)this.getSize();
    }

    public SampleDescriptionBox getSampleDescription() {
        return this.sampleDescription;
    }

    public TimeToSampleBox getTimeToSampleBox() {
        return this.timeToSampleBox;
    }

    public SampleToChunkBox getSampleToChunkBox() {
        return this.sampleToChunkBox;
    }

    public SampleSizeBox getSampleSizeBox() {
        return this.sampleSizeBox;
    }

    public ChunkOffsetBox getChunkOffsetBox() {
        return this.chunkOffsetBox;
    }

    public SyncSampleBox getSyncSampleBox() {
        return this.syncSampleBox;
    }

    public CompositionOffsetBox getCompositionOffsetBox() {
        return this.compositionOffsetBox;
    }

    static {
        bytetoTypeMap.put(TYPE, TYPE_S);
    }
}

