/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.phone;

import java.io.IOException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.NotifyEventImpl;
import org.mobicents.media.server.impl.resource.GoertzelFilter;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.events.NotifyEvent;

public class PhoneSignalDetector
extends AbstractSink {
    private static final int STATE_IDLE = 0;
    private static final int STATE_SIGNAL = 1;
    private static final int STATE_SILENCE = 2;
    private int POWER = 10000;
    private int state = 0;
    private static final double E = 100.0;
    private static final int PACKET_DURATION = 50;
    private static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO};
    private int[] T;
    private int[] f;
    private int offset;
    private int toneDuration = 50;
    private int N = 8 * this.toneDuration;
    private double scale = (double)this.toneDuration / 1000.0;
    private GoertzelFilter[] freqFilters;
    private double[] signal = new double[this.N];
    private double maxAmpl;
    private double threshold;
    private int level;
    private double[] p;
    private long startTime;
    private int count;
    private NotifyEvent event;

    public PhoneSignalDetector(String name) {
        super(name);
    }

    public int getEventID() {
        return this.event != null ? this.event.getEventID() : 0;
    }

    public void setEventID(int eventID) {
        this.event = new NotifyEventImpl(this, eventID);
    }

    public void setPeriods(int[] T) {
        this.T = T;
    }

    public int[] getPeriods() {
        return this.T;
    }

    public void setFrequency(int[] f) {
        this.f = f;
        this.freqFilters = new GoertzelFilter[f.length];
        this.p = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            this.freqFilters[i] = new GoertzelFilter(f[i], this.N, this.scale);
        }
    }

    public int[] getFrequency() {
        return this.f;
    }

    public void setVolume(int level) {
        this.level = level;
        this.threshold = Math.pow(Math.pow(10.0, level), 0.1) * 32767.0;
    }

    public int getVolume() {
        return this.level;
    }

    public void onMediaTransfer(Buffer buffer) throws IOException {
        byte[] data = buffer.getData();
        int M = data.length;
        int k = 0;
        while (k < M) {
            while (this.offset < this.N && k < M - 1) {
                int n = k++;
                int n2 = k++;
                double s = data[n] & 0xFF | data[n2] << 8;
                double sa = Math.abs(s);
                if (sa > this.maxAmpl) {
                    this.maxAmpl = sa;
                }
                this.signal[this.offset++] = s;
            }
            if (this.offset != this.N) continue;
            this.offset = 0;
            if (this.maxAmpl >= this.threshold) {
                this.maxAmpl = 0.0;
                this.getPower(this.freqFilters, this.signal, 0, this.p);
                if (this.isDetected()) {
                    this.notifySignal();
                    continue;
                }
                this.notifyNoSignal();
                continue;
            }
            this.notifySilence();
        }
    }

    private void notifySignal() {
        switch (this.state) {
            case 0: {
                this.startTime = System.currentTimeMillis();
                this.state = 1;
                break;
            }
            case 2: {
                long now = System.currentTimeMillis();
                long duration = now - this.startTime;
                if ((double)Math.abs(duration - (long)(this.T[1] * 1000)) < 100.0) {
                    this.state = 1;
                    this.startTime = now;
                    break;
                }
                this.count = 0;
                this.state = 0;
            }
        }
    }

    private void notifySilence() {
        switch (this.state) {
            case 1: {
                long now = System.currentTimeMillis();
                long duration = now - this.startTime;
                if ((double)Math.abs(duration - (long)(this.T[0] * 1000)) < 100.0) {
                    ++this.count;
                    if (this.count == 3) {
                        this.state = 0;
                        this.count = 0;
                        this.sendEvent(this.event);
                        break;
                    }
                    this.state = 2;
                    this.startTime = now;
                    break;
                }
                this.count = 0;
                this.state = 0;
            }
        }
    }

    private void notifyNoSignal() {
        switch (this.state) {
            case 1: {
                this.count = 0;
                this.state = 0;
            }
        }
    }

    private boolean isDetected() {
        for (double P : this.p) {
            if (!(P <= (double)this.POWER)) continue;
            return false;
        }
        return true;
    }

    private void getPower(GoertzelFilter[] filters, double[] data, int offset, double[] power) {
        for (int i = 0; i < filters.length; ++i) {
            power[i] = filters[i].getPower(data, offset);
        }
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public boolean isAcceptable(Format format) {
        return format.matches((Format)Codec.LINEAR_AUDIO);
    }
}

