/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.prelay;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.ConnectionImpl;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSinkSet;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.impl.AbstractSourceSet;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.dsp.DspFactory;
import org.mobicents.media.server.impl.resource.prelay.AudioChannel;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bridge
extends BaseComponent
implements ResourceGroup {
    private AudioChannel[] audioChannels = new AudioChannel[2];
    private Input input;
    private Output output;
    private static ArrayList<MediaType> mediaTypes = new ArrayList();

    public Bridge(String name, DspFactory dspFactory, Endpoint endpoint) {
        super(name);
        this.audioChannels[0] = new AudioChannel(dspFactory);
        this.audioChannels[1] = new AudioChannel(dspFactory);
        this.input = new Input("PacketRelay[Input]");
        this.output = new Output("PacketRelay[Output]");
    }

    public Collection<MediaType> getMediaTypes() {
        return mediaTypes;
    }

    public MediaSource getSource(MediaType media) {
        return media == MediaType.AUDIO ? this.output : null;
    }

    public MediaSink getSink(MediaType media) {
        return media == MediaType.AUDIO ? this.input : null;
    }

    public void start() {
    }

    public void stop() {
    }

    static {
        mediaTypes.add(MediaType.AUDIO);
    }

    private class Output
    extends AbstractSourceSet {
        public Output(String name) {
            super(name);
        }

        public void start() {
        }

        public void stop() {
        }

        public void evolve(Buffer buffer, long timestamp) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Format[] getFormats() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AbstractSource createSource(MediaSink otherParty) {
            ConnectionImpl connection = (ConnectionImpl)otherParty.getConnection();
            int idx = Math.abs(connection.getIndex() - 1);
            return (AbstractSource)Bridge.this.audioChannels[idx].getOutput();
        }

        public void destroySource(AbstractSource source) {
        }
    }

    private class Input
    extends AbstractSinkSet {
        public Input(String name) {
            super(name);
        }

        public void start() {
        }

        public void stop() {
        }

        public Format[] getFormats() {
            return null;
        }

        public boolean isAcceptable(Format format) {
            return false;
        }

        public void onMediaTransfer(Buffer buffer) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AbstractSink createSink(MediaSource otherParty) {
            ConnectionImpl connection = (ConnectionImpl)otherParty.getConnection();
            int idx = connection.getIndex();
            return (AbstractSink)Bridge.this.audioChannels[idx].getInput();
        }

        public void destroySink(AbstractSink sink) {
        }
    }
}

