/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.test;

import java.io.IOException;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.resource.test.MeanderEvent;
import org.mobicents.media.server.spi.dsp.Codec;

public class MeanderDetector
extends AbstractSink {
    private static final Format[] FORMATS = new Format[]{Codec.LINEAR_AUDIO};
    private int sampleRate = (int)Codec.LINEAR_AUDIO.getSampleRate();
    private double T;
    private short A;
    private short[] localBuffer;
    private int size;
    private int offset;
    private int count;
    private long seq;
    private boolean first = true;

    public MeanderDetector(String name) {
        super(name);
    }

    public void setPeriod(double T) {
        this.T = T / 2.0;
        this.size = (int)((double)this.sampleRate * this.T);
        this.localBuffer = new short[4 * this.size];
    }

    public void setAmplitude(short A) {
        this.A = A;
    }

    public Format[] getFormats() {
        return FORMATS;
    }

    public boolean isAcceptable(Format format) {
        return format.matches((Format)Codec.LINEAR_AUDIO);
    }

    public void start() {
        this.seq = 0L;
        this.first = true;
        super.start();
    }

    private boolean checkShock(short a, short b) {
        if (a == 0) {
            return b == this.A;
        }
        if (a == this.A) {
            return b == 0;
        }
        return false;
    }

    private void analysis() {
        int p1 = 0;
        for (int i = 0; i < this.localBuffer.length - 1; ++i) {
            if (this.localBuffer[i] == this.localBuffer[i + 1]) continue;
            int delta = i - p1;
            p1 = i;
            if (Math.abs(delta - this.size) >= 2) continue;
            ++this.count;
            if (this.count != 3 || !this.checkShock(this.localBuffer[i], this.localBuffer[i + 1])) continue;
            this.count = 0;
            this.sendEvent(new MeanderEvent(this, 0));
            break;
        }
    }

    public void onMediaTransfer(Buffer buffer) throws IOException {
        if (!this.first && buffer.getSequenceNumber() - this.seq != 1L) {
            this.sendEvent(new MeanderEvent(this, 1));
        }
        this.seq = buffer.getSequenceNumber();
        if (this.first) {
            this.first = false;
        }
        if (!buffer.getFormat().matches((Format)Codec.LINEAR_AUDIO)) {
            this.sendEvent(new MeanderEvent(this, 2));
        }
        byte[] data = buffer.getData();
        for (int i = 0; i < buffer.getLength() - 1; i += 2) {
            if (this.offset < this.localBuffer.length) {
                short v = (short)(data[i + buffer.getOffset()] & 0xFF | data[i + 1 + buffer.getOffset()] << 8);
                this.localBuffer[this.offset++] = v;
                continue;
            }
            this.analysis();
            this.offset = 0;
        }
    }
}

