/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.zap;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.mobicents.media.server.impl.resource.zap.Selector;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.ss7.mtp.Mtp2;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.SelectorProvider;
import org.mobicents.protocols.stream.api.StreamSelector;

public class Channel
implements Mtp1 {
    private static final String MMS_HOME = "MMS_HOME";
    private static final String LIB_NAME = "zap-native-linux.so";
    private int span;
    private int channelID;
    private int code;
    private String linkName;
    protected int fd;
    private Mtp2 link;
    protected SelectorKey selectorKey;

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public void setChannelID(int channelID) {
        this.channelID = channelID;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void open() {
        int zapid = 31 * (this.span - 1) + this.channelID;
        this.fd = this.openChannel(zapid);
    }

    public native int openChannel(int var1);

    public int read(byte[] buffer) throws IOException {
        return this.readData(this.fd, buffer);
    }

    public native int readData(int var1, byte[] var2);

    public int write(byte[] buffer) throws IOException {
        this.writeData(this.fd, buffer, buffer.length);
        return 0;
    }

    public native void writeData(int var1, byte[] var2, int var3);

    public native void doRegister(int var1);

    public native void doUnregister(int var1);

    public void close() {
        this.closeChannel(this.fd);
    }

    public native void closeChannel(int var1);

    public String toString() {
        return Integer.toString(this.channelID);
    }

    public void setLink(Mtp2 link) {
        this.link = link;
    }

    public Mtp2 getLink() {
        return this.link;
    }

    protected void doRegister(StreamSelector selector) {
        this.doRegister(this.fd);
    }

    protected void doUnregister(StreamSelector selector) {
        this.doUnregister(this.fd);
    }

    public boolean isReadable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWriteable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SelectorProvider provider() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SelectorKey register(StreamSelector selector) throws IOException {
        return ((Selector)selector).register(this);
    }

    public void write(byte[] data, int len) throws IOException {
        this.writeData(this.fd, data, len);
    }

    static {
        try {
            Map<String, String> env = System.getenv();
            if (env.get(MMS_HOME) != null) {
                String path = env.get(MMS_HOME) + File.separator + "native" + File.separator + LIB_NAME;
                System.load(path);
                System.out.println("Loaded library " + path);
            } else {
                System.out.println("Can not load library");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

