/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.zap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.mobicents.media.Server;
import org.mobicents.media.server.impl.clock.LocalTask;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.protocols.link.DataLink;
import org.mobicents.protocols.link.LinkState;
import org.mobicents.protocols.link.LinkStateListener;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.ss7.mtp.Mtp2;
import org.mobicents.protocols.ss7.mtp.Mtp3;
import org.mobicents.protocols.ss7.mtp.Mtp3Listener;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.SelectorProvider;
import org.mobicents.protocols.stream.api.StreamSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTPUser
implements Task,
Mtp3Listener,
LinkStateListener {
    private String name;
    private int opc;
    private int dpc;
    private List<Mtp1> channels;
    private Mtp3 mtp3;
    private Logger logger = Logger.getLogger(MTPUser.class);
    private volatile boolean isActive = false;
    private LocalTask task;
    private DataLink dataLink;
    private StreamSelector selector;
    private InetSocketAddress address;
    private InetSocketAddress remote;
    private int localPort;
    private int remotePort;
    private String localAddress;
    private String remoteAddress;
    private byte[] rxBuffer = new byte[279];
    private ConcurrentLinkedQueue<byte[]> queue = new ConcurrentLinkedQueue();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOpc(int opc) {
        this.opc = opc;
    }

    public void setDpc(int dpc) {
        this.dpc = dpc;
    }

    public int getOpc() {
        return this.opc;
    }

    public int getDpc() {
        return this.dpc;
    }

    public void setLocalAddress(String address) {
        this.localAddress = address;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setRemoteAddress(String address) {
        this.remoteAddress = address;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setChannels(List<Mtp1> channels) {
        this.channels = channels;
    }

    public void start() throws IOException, ClassNotFoundException {
        try {
            this.address = new InetSocketAddress(this.localAddress, this.localPort);
            this.remote = new InetSocketAddress(this.remoteAddress, this.remotePort);
            this.dataLink = DataLink.open((InetSocketAddress)this.address, (InetSocketAddress)this.remote);
            this.dataLink.setListener((LinkStateListener)this);
            this.selector = SelectorProvider.getSelector((String)"org.mobicents.protocols.link.SelectorImpl");
            this.dataLink.register(this.selector);
            this.dataLink.activate();
            this.logger.info((Object)"Created MTP layer 3");
            ArrayList<Mtp2> linkset = new ArrayList<Mtp2>();
            for (Mtp1 channel : this.channels) {
                Mtp2 link = new Mtp2(this.name + "-" + channel.getCode(), channel);
                linkset.add(link);
            }
            this.mtp3 = new Mtp3(this.name);
            this.mtp3.setDpc(this.dpc);
            this.mtp3.setOpc(this.opc);
            this.mtp3.setLinks(linkset);
            this.mtp3.addMtp3Listener((Mtp3Listener)this);
            this.logger.info((Object)"Point codes are configured");
            this.mtp3.start();
            this.isActive = true;
            this.task = Server.scheduler.execute(this);
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public void stop() {
        this.task.cancel();
    }

    public void cancel() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int perform() {
        Collection keys;
        this.mtp3.run();
        try {
            keys = this.selector.selectNow(1, 20);
            for (SelectorKey key : keys) {
                int len = key.getStream().read(this.rxBuffer);
                this.mtp3.send(this.rxBuffer, len);
            }
        }
        catch (IOException e) {
            return -1;
        }
        try {
            keys = this.selector.selectNow(2, 20);
            for (SelectorKey key : keys) {
                if (this.queue.isEmpty()) continue;
                byte[] msu = this.queue.poll();
                key.getStream().write(msu);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1;
    }

    public void linkUp() {
        this.dataLink.activate();
        this.queue.clear();
    }

    public void linkDown() {
        this.dataLink.deactivate();
    }

    public void receive(byte[] data) {
        this.queue.offer(data);
    }

    public void onStateChange(LinkState state) {
        if (state == LinkState.ACTIVE) {
            this.queue.clear();
        }
    }
}

