/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.zap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.resource.zap.Channel;
import org.mobicents.media.server.impl.resource.zap.SelectorKeyImpl;
import org.mobicents.protocols.ss7.mtp.Mtp1;
import org.mobicents.protocols.stream.api.SelectorKey;
import org.mobicents.protocols.stream.api.Stream;
import org.mobicents.protocols.stream.api.StreamSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector
implements StreamSelector {
    private static final String MMS_HOME = "MMS_HOME";
    private static final String LIB_NAME = "zap-native-linux.so";
    public static final int READ = 1;
    public static final int WRITE = 2;
    private int[] fds = new int[16];
    private ArrayList<Mtp1> registered = new ArrayList();
    private int ops;
    private ArrayList<SelectorKey> selected = new ArrayList();
    private static Logger logger = Logger.getLogger(Selector.class);

    public SelectorKey register(Channel channel) {
        this.registered.add(channel);
        logger.info((Object)("Registering file descriptor:" + channel.fd));
        this.doRegister(channel.fd);
        SelectorKeyImpl key = new SelectorKeyImpl(channel, this);
        channel.selectorKey = key;
        return key;
    }

    public void unregister(Channel channel) {
        this.registered.remove(channel);
        channel.selectorKey = null;
        this.doUnregister(channel.fd);
    }

    public native void doRegister(int var1);

    public native void doUnregister(int var1);

    public native int doPoll(int[] var1, int var2, int var3);

    public Collection<SelectorKey> selectNow(int ops, int timeout) throws IOException {
        int count = this.doPoll(this.fds, ops, 20);
        this.selected.clear();
        for (int i = 0; i < count; ++i) {
            for (Mtp1 chan : this.registered) {
                Channel channel = (Channel)chan;
                if (channel.fd != this.fds[i]) continue;
                this.selected.add(channel.selectorKey);
            }
        }
        return this.selected;
    }

    public void setOperation(int v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getOperations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isReadOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWriteOperation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Stream> getRegisteredStreams() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        try {
            Map<String, String> env = System.getenv();
            if (env.get(MMS_HOME) != null) {
                String path = env.get(MMS_HOME) + File.separator + "native" + File.separator + LIB_NAME;
                System.load(path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

