/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.resource.zap;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.mobicents.media.server.ConnectionFactory;
import org.mobicents.media.server.impl.resource.zap.DahdiEndpointImpl;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointFactory;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.rtp.RtpManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trunk
implements EndpointFactory {
    private ArrayList<Endpoint> endpoints = new ArrayList();
    private String name;
    private RtpManager rtpFactory;
    private ConnectionFactory connectionFactory;
    private int span;
    private String ranges;
    private int[] firstCIC;
    private boolean linkUp = false;
    private static Logger logger = Logger.getLogger(Trunk.class);

    public void setName(String name) {
        this.name = name;
    }

    public void setFirstCIC(String cic) {
        String[] tokens = cic.split(",");
        this.firstCIC = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            this.firstCIC[i] = Integer.parseInt(tokens[i]);
        }
    }

    public void setSpan(int span) {
        this.span = span;
    }

    public void setChannels(String ranges) {
        this.ranges = ranges;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setRtpManager(RtpManager rtpFactory) {
        this.rtpFactory = rtpFactory;
    }

    public RtpManager getRtpManager() {
        return this.rtpFactory;
    }

    public void linkUp() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Received L4 Up event from layer3.");
        }
        this.linkUp = true;
    }

    public void linkDown() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Received L4 Down event from layer3.");
        }
        this.linkUp = false;
    }

    public void receive(byte[] arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<Endpoint> install() throws ResourceUnavailableException {
        String[] subranges = this.ranges.split(",");
        for (int i = 0; i < subranges.length; ++i) {
            String[] tokens = subranges[i].split("-");
            int low = Integer.parseInt(tokens[0]);
            int high = Integer.parseInt(tokens[1]);
            for (int k = low; k <= high; ++k) {
                int zapid = 31 * (this.span - 1) + k;
                String path = "/dev/dahdi/" + zapid;
                DahdiEndpointImpl endpoint = new DahdiEndpointImpl(this.name + "/" + k, path);
                endpoint.setRtpManager(this.rtpFactory);
                endpoint.setConnectionFactory(this.connectionFactory);
                this.endpoints.add(endpoint);
            }
        }
        return this.endpoints;
    }

    public void uninstall() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

