/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.mobicents.media.Server;
import org.mobicents.media.server.impl.rtp.RtpFactory;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.RtpSocketImpl;
import org.mobicents.media.server.spi.clock.Task;
import org.mobicents.media.server.spi.clock.TimerTask;

public class Receiver
implements Task {
    public static final int POLL_PERIOD = 20;
    private Selector selector;
    private int bufferSize = 8196;
    private ByteBuffer readBuffer = ByteBuffer.allocateDirect(this.bufferSize);
    private volatile boolean started;
    private RtpFactory factory;
    private Logger logger = Logger.getLogger(Receiver.class);
    private TimerTask worker;

    public Receiver(RtpFactory factory) throws IOException {
        this.factory = factory;
        this.selector = SelectorProvider.provider().openSelector();
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void start() {
        this.started = true;
        this.worker = Server.scheduler.execute(this);
    }

    public void stop() {
        this.worker.cancel();
        this.started = false;
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancel() {
        this.stop();
    }

    public boolean isActive() {
        return this.started;
    }

    public int perform() {
        if (!this.started) {
            return -1;
        }
        try {
            this.selector.selectNow();
        }
        catch (IOException e) {
            this.factory.notify(e);
            return -1;
        }
        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
        block4: while (keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            DatagramChannel channel = (DatagramChannel)key.channel();
            RtpSocketImpl socket = (RtpSocketImpl)key.attachment();
            if (!key.isReadable()) continue;
            if (socket.isClosed()) {
                socket.close();
                continue;
            }
            int len = 1;
            while (len > 0) {
                try {
                    if (socket.isClosed()) {
                        len = 0;
                        continue;
                    }
                    len = channel.read(this.readBuffer);
                    this.readBuffer.flip();
                    if (len <= 0) {
                        this.readBuffer.clear();
                        continue block4;
                    }
                    RtpPacket rtpPacket = new RtpPacket(this.readBuffer);
                    socket.receive(rtpPacket);
                    this.readBuffer.clear();
                }
                catch (IOException e) {}
            }
        }
        this.factory.register();
        return 20;
    }
}

