/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.client.NetworkConfigurationDiscoveryProcess;
import net.java.stun4j.client.StunDiscoveryReport;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.BufferConcurrentLinkedQueue;
import org.mobicents.media.server.impl.rtp.Receiver;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpSocketImpl;
import org.mobicents.media.server.impl.rtp.clock.AudioClock;
import org.mobicents.media.server.impl.rtp.clock.VideoClock;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;
import org.mobicents.media.server.spi.rtp.AVProfile;
import org.mobicents.media.server.spi.rtp.RtpListener;
import org.mobicents.media.server.spi.rtp.RtpManager;
import org.mobicents.media.server.spi.rtp.RtpSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpFactory
implements RtpManager {
    private Receiver receiver;
    private Integer jitter = 60;
    private InetAddress bindAddress;
    protected InetSocketAddress publicAddress;
    private String stunHost;
    private int stunPort = 3478;
    private AVProfile avProfile = new AVProfile();
    private Hashtable<MediaType, List<CodecFactory>> codecFactories;
    protected BufferConcurrentLinkedQueue<RtpSocketImpl> registerQueue = new BufferConcurrentLinkedQueue();
    private int portIndex;
    private int lowPort = 1024;
    private int highPort = 65535;
    protected RtpListener listener;
    private transient Logger logger = Logger.getLogger(RtpFactory.class);

    public void setListener(RtpListener listener) {
        this.listener = listener;
    }

    public RtpListener getListener() {
        return this.listener;
    }

    protected void notify(Exception e) {
        if (this.listener != null) {
            this.listener.notify(e);
        }
    }

    public String getStunAddress() {
        return this.stunHost == null ? null : (this.stunPort == 3478 ? this.stunHost : this.stunHost + ":" + this.stunPort);
    }

    public void setStunAddress(String address) {
        String[] tokens = address.split(":");
        this.stunHost = tokens[0];
        if (tokens.length == 2) {
            this.stunPort = Integer.parseInt(tokens[1]);
        }
    }

    public void start(long now) throws SocketException, IOException {
        this.portIndex = this.lowPort;
        this.receiver = new Receiver(this);
        this.receiver.start();
    }

    public boolean isActive() {
        return this.receiver.isActive();
    }

    protected int getNextPort() {
        this.portIndex += 2;
        if (this.portIndex > this.highPort) {
            this.portIndex = this.lowPort;
        }
        return this.portIndex;
    }

    public void stop() {
        this.receiver.stop();
    }

    public String getBindAddress() {
        return this.bindAddress != null ? this.bindAddress.getHostAddress() : null;
    }

    public void setBindAddress(String bindAddress) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(bindAddress);
    }

    public int getLowPort() {
        return this.lowPort;
    }

    public void setLowPort(int lowPort) {
        this.lowPort = lowPort;
    }

    public int getHighPort() {
        return this.highPort;
    }

    public void setHighPort(int port) {
        this.highPort = port;
    }

    public Integer getJitter() {
        return this.jitter;
    }

    public void setJitter(Integer jitter) {
        this.jitter = jitter;
    }

    public AVProfile getAVProfile() {
        return this.avProfile;
    }

    public void setAVProfile(AVProfile avProfile) {
        this.avProfile = avProfile;
    }

    public RtpClock getClock(MediaType media) {
        if (media == MediaType.AUDIO) {
            return new AudioClock();
        }
        if (media == MediaType.VIDEO) {
            return new VideoClock();
        }
        return null;
    }

    public Hashtable<MediaType, List<CodecFactory>> getCodecs() {
        return this.codecFactories;
    }

    public void setCodecs(Hashtable<MediaType, List<CodecFactory>> codecFactories) {
        this.codecFactories = codecFactories;
    }

    protected void register() {
        while (!this.registerQueue.isEmpty()) {
            RtpSocketImpl socket = this.registerQueue.poll();
            try {
                socket.register(this.receiver.getSelector());
            }
            catch (ClosedChannelException e) {
                socket.notify(e);
            }
        }
    }

    public RtpSocket getRTPSocket(MediaType media) throws IOException, ResourceUnavailableException {
        if (!this.isActive()) {
            throw new ResourceUnavailableException("Receiver is not running");
        }
        RtpSocketImpl rtpSocket = new RtpSocketImpl(this, this.getCodecs(media), media);
        return rtpSocket;
    }

    private ArrayList<Codec> getCodecs(MediaType media) {
        Collection factories;
        ArrayList<Codec> codecs = new ArrayList<Codec>();
        if (this.codecFactories != null && (factories = (Collection)this.codecFactories.get(media)) != null) {
            for (CodecFactory factory : factories) {
                codecs.add(factory.getCodec());
            }
        }
        return codecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetSocketAddress getPublicAddress(InetSocketAddress localAddress) throws StunException {
        StunAddress local = new StunAddress(localAddress.getAddress(), localAddress.getPort());
        StunAddress stun = new StunAddress(this.stunHost, this.stunPort);
        NetworkConfigurationDiscoveryProcess addressDiscovery = new NetworkConfigurationDiscoveryProcess(local, stun);
        try {
            addressDiscovery.start();
            StunDiscoveryReport report = addressDiscovery.determineAddress();
            InetSocketAddress inetSocketAddress = report.getPublicAddress().getSocketAddress();
            return inetSocketAddress;
        }
        finally {
            addressDiscovery.shutDown();
        }
    }
}

