/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.Serializable;

public class RtpHeader
implements Serializable {
    private int version = 2;
    private boolean padding = false;
    private boolean extensions = false;
    private int cc = 0;
    private boolean marker = false;
    private int payloadType;
    private int seqNumber;
    private long timestamp;
    private long ssrc;
    private byte[] bin = new byte[12];
    private int pos = 0;
    private boolean filled = false;

    public void RtpHeader() {
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void init(byte[] bin) {
        this.bin = bin;
        int b = bin[0] & 0xFF;
        this.version = (b & 0xC) >> 6;
        this.padding = (b & 0x20) == 32;
        this.extensions = (b & 0x10) == 16;
        this.cc = b & 0xF;
        b = bin[1] & 0xFF;
        this.marker = (b & 0x80) == 128;
        this.payloadType = b & 0x7F;
        this.seqNumber = (bin[2] & 0xFF) << 8;
        this.seqNumber |= bin[3] & 0xFF;
        this.timestamp = bin[4] & 0xFF;
        this.timestamp = this.timestamp << 8 | (long)(bin[5] & 0xFF);
        this.timestamp = this.timestamp << 8 | (long)(bin[6] & 0xFF);
        this.timestamp = this.timestamp << 8 | (long)(bin[7] & 0xFF);
        this.ssrc = bin[8] & 0xFF;
        this.ssrc = this.ssrc << 8 | (long)(bin[9] & 0xFF);
        this.ssrc = this.ssrc << 8 | (long)(bin[10] & 0xFF);
        this.ssrc = this.ssrc << 8 | (long)(bin[11] & 0xFF);
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public boolean isExtensions() {
        return this.extensions;
    }

    public int getCc() {
        return this.cc;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public byte[] toByteArray() {
        return this.bin;
    }

    public boolean getMarker() {
        return this.marker;
    }

    public void setMarker(boolean marker) {
        this.marker = marker;
    }

    protected int append(byte[] data, int offset, int len) {
        int remainder = Math.min(12 - this.pos, len);
        System.arraycopy(data, offset, this.bin, this.pos, remainder);
        this.pos += remainder;
        if (this.pos == 12) {
            this.init(this.bin);
            this.filled = true;
        }
        return len - remainder;
    }

    public void init(boolean marker, byte payloadType, int seqNumber, int timestamp, long ssrc) {
        this.payloadType = payloadType;
        this.seqNumber = seqNumber;
        this.timestamp = timestamp;
        this.ssrc = ssrc;
        this.marker = marker;
        this.bin[0] = -128;
        this.bin[1] = marker ? (byte)(payloadType | 0x80) : (byte)(payloadType & 0x7F);
        this.bin[2] = (byte)(seqNumber >> 8);
        this.bin[3] = (byte)seqNumber;
        this.bin[4] = (byte)(timestamp >> 24);
        this.bin[5] = (byte)(timestamp >> 16);
        this.bin[6] = (byte)(timestamp >> 8);
        this.bin[7] = (byte)timestamp;
        this.bin[8] = (byte)(ssrc >> 24);
        this.bin[9] = (byte)(ssrc >> 16);
        this.bin[10] = (byte)(ssrc >> 8);
        this.bin[11] = (byte)ssrc;
    }

    public void init(byte payloadType, int seqNumber, int timestamp, long ssrc) {
        this.init(false, (byte)(payloadType & 0x7F), seqNumber, timestamp, ssrc);
    }

    public String toString() {
        return "ssrc=" + this.ssrc + ", timestamp=" + this.timestamp + ", seq=" + this.seqNumber + ", payload=" + this.payloadType;
    }
}

