/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.resource.dtmf.DtmfEvent;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.RtpSocketImpl;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.rtp.AVProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendStream
extends AbstractSink {
    private int seq = 0;
    private final long ssrc = System.currentTimeMillis();
    private RtpSocketImpl rtpSocket;
    protected RtpClock clock;
    private ArrayList<Format> formats = new ArrayList();
    protected byte mainstream;
    private byte dtmf;
    private long time;
    private Codec codec;
    private AVProfile formatConfig;
    private int eventDuration;
    private boolean endOfEvent;
    protected long byteCount;

    public SendStream(RtpSocketImpl rtpSocket, AVProfile avProfile) {
        super("SendStream");
        this.rtpSocket = rtpSocket;
        this.formatConfig = avProfile;
        this.clock = rtpSocket.getClock();
    }

    @Override
    public void connect(MediaSource source) {
        if (this.rtpSocket.getFormat() == null) {
            throw new IllegalStateException("RTP has no negotiated formats");
        }
        super.connect(source);
    }

    public void setDtmf(int dtmf) {
        this.dtmf = (byte)dtmf;
    }

    @Override
    protected Format selectPreffered(Collection<Format> set) {
        for (Format f : set) {
            if (!f.matches(this.rtpSocket.getFormat())) continue;
            this.codec = null;
            return f;
        }
        for (Format f : set) {
            for (Codec c : this.rtpSocket.codecs) {
                if (!f.matches(c.getSupportedInputFormat()) || !c.getSupportedOutputFormat().matches(this.rtpSocket.getFormat())) continue;
                this.codec = c;
                return f;
            }
        }
        return null;
    }

    @Override
    public void onMediaTransfer(Buffer buffer) throws IOException {
        RtpPacket packet = null;
        if (buffer.getFormat() == Format.RAW_RTP) {
            this.rtpSocket.send(buffer.getData());
            return;
        }
        if (this.codec != null) {
            this.codec.process(buffer);
        }
        boolean marker = (buffer.getFlags() & 0x10) == 16;
        int timestamp = (int)this.clock.getTimestamp(buffer.getTimeStamp());
        if (buffer.getHeader() != null && buffer.getHeader() instanceof DtmfEvent && this.dtmf > 0) {
            DtmfEvent evt = (DtmfEvent)buffer.getHeader();
            int digit = evt.getEventID();
            int volume = evt.getVolume();
            byte[] data = new byte[]{(byte)digit, this.endOfEvent ? (byte)(volume | 0x80) : (byte)(volume & 0x7F), (byte)(this.eventDuration >> 8), (byte)this.eventDuration};
            this.eventDuration += 160;
            packet = new RtpPacket(false, this.dtmf, this.seq++, timestamp, this.ssrc, data, 0, 4);
        } else {
            packet = new RtpPacket(marker, this.mainstream, this.seq++, timestamp, this.ssrc, buffer.getData(), buffer.getOffset(), buffer.getLength());
        }
        this.byteCount += (long)(buffer.getLength() + 12);
        this.rtpSocket.send(packet);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sending " + packet));
        }
    }

    protected void reset() {
        this.mainstream = (byte)-1;
        this.byteCount = 0L;
    }

    public boolean isAcceptable(Format fmt) {
        return true;
    }

    protected void setFormat(int payloadID, Format format) {
        this.mainstream = (byte)payloadID;
        if (format != Format.ANY) {
            this.clock.setFormat(format);
        }
        this.formats.clear();
        this.formats.add(format);
        for (Codec c : this.rtpSocket.codecs) {
            if (!c.getSupportedOutputFormat().matches(format)) continue;
            this.formats.add(c.getSupportedInputFormat());
        }
    }

    public Format[] getFormats() {
        if (this.rtpSocket.getFormat() == null) {
            return new Format[0];
        }
        Format[] fmts = new Format[this.formats.size()];
        this.formats.toArray(fmts);
        return fmts;
    }
}

