/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TestNio {
    private static transient ExecutorService pool = Executors.newFixedThreadPool(10, new ThreadFactoryImpl());
    private static ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();
    private Thread worker;
    private volatile boolean started = false;
    private static String mcAddress = "127.0.0.1";

    public static void main(String[] args) throws Exception {
        TestNio t = new TestNio();
        t.doTest();
    }

    public void doTest() throws Exception {
        int i;
        int N = 250;
        this.started = true;
        Receiver r = new Receiver();
        Server1[] servers = new Server1[N];
        for (int i2 = 0; i2 < N; ++i2) {
            servers[i2] = new Server1(i2);
            r.add(servers[i2]);
        }
        System.out.println("Servers are ready ");
        this.worker = new Thread(r);
        this.worker.start();
        Client1[] clients = new Client1[N];
        for (i = 0; i < N; ++i) {
            clients[i] = new Client1(i);
            timer.scheduleAtFixedRate(clients[i], 0L, 20L, TimeUnit.MILLISECONDS);
        }
        Thread.currentThread();
        Thread.sleep(60000L);
        timer.shutdown();
        this.started = false;
        pool.shutdown();
        for (i = 0; i < N; ++i) {
            servers[i].stop();
        }
        clients[50].printTicks();
        System.out.println("===============================");
        servers[50].printTicks();
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        final ThreadGroup group;
        static final AtomicInteger msProviderPoolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "MsProviderImpl-FixedThreadPool-" + msProviderPoolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 1) {
                t.setPriority(1);
            }
            return t;
        }
    }

    private class Server1
    implements Runnable {
        private DatagramChannel channel;
        private ByteBuffer buffer = ByteBuffer.allocate(1000);
        private ArrayList<Long> ticks = new ArrayList(5000);
        private Selector selector;

        public Server1(int index) throws SocketException, IOException {
            int port = 6000 + index;
            InetSocketAddress address = new InetSocketAddress(mcAddress, port);
            this.channel = DatagramChannel.open();
            System.out.println("Channel is open " + index);
            this.channel.socket().bind(address);
            System.out.println("Socket is bound to " + address);
            this.channel.connect(new InetSocketAddress(mcAddress, port + 2000));
            System.out.println("Socket is connected to port " + (port + 2000));
            this.selector = Selector.open();
            this.channel.configureBlocking(false);
            System.out.println("Selected opened");
            this.channel.register(this.selector, 1);
            System.out.println("Selected - 0");
        }

        public void stop() throws IOException {
            this.selector.close();
            this.channel.disconnect();
            this.channel.close();
            this.channel.socket().close();
        }

        public void run() {
            try {
                int count = this.channel.read(this.buffer);
                if (count != 160) {
                    System.out.println("BAD!BAD!BAD!BAD! " + count);
                }
                this.buffer.flip();
                this.buffer.clear();
                if (count > 0) {
                    this.ticks.add(System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void printTicks() {
            System.out.println("Packets " + this.ticks.size());
            long jitter = 0L;
            for (int i = 1; i < this.ticks.size(); ++i) {
                long diff = this.ticks.get(i) - this.ticks.get(i - 1);
                System.out.println("diff =" + diff);
                jitter += diff - 20L;
            }
            System.out.println("Jitter avg = " + jitter);
        }
    }

    private class Signal
    implements Runnable {
        int newSignalThreads = 3;
        private int index = 0;

        private Signal() {
        }

        public void run() {
            while (TestNio.this.started) {
                for (int i = 0; i < this.newSignalThreads; ++i) {
                    Runnable task = new Runnable(){

                        public void run() {
                            Signal.this.index = Signal.this.index + 1;
                            try {
                                double randNumber = Math.random();
                                double sqrt = Math.sqrt(randNumber);
                                System.out.println("Signalling done for index = " + Signal.this.index + " randNumber = " + randNumber + " sqrt = " + sqrt);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    pool.submit(task);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Signal Thread terminated");
        }
    }

    private class Receiver
    implements Runnable {
        private ArrayList<Server1> list = new ArrayList();

        private Receiver() {
        }

        public void add(Server1 s) {
            this.list.add(s);
        }

        public void run() {
            System.out.println("Worker started: " + this.list.size() + " started = " + TestNio.this.started);
            while (TestNio.this.started) {
                for (Server1 receiver : this.list) {
                    receiver.run();
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("Worker terminated");
        }
    }

    private class Server
    implements Runnable {
        private DatagramSocket socket;
        private boolean stopped = false;
        private ArrayList<Long> ticks = new ArrayList(5000);
        int port = 6000;

        public Server(int index) throws SocketException {
            this.port += index;
            InetSocketAddress address = new InetSocketAddress(mcAddress, this.port);
            this.socket = new DatagramSocket(address);
            new Thread(this).start();
        }

        public void stop() {
            this.stopped = true;
            this.socket.close();
        }

        public void run() {
            byte[] buffer = new byte[1000];
            DatagramPacket packet = new DatagramPacket(buffer, 1000);
            System.out.println("Started server at port = " + this.port);
            while (!this.stopped) {
                try {
                    this.socket.receive(packet);
                    this.ticks.add(System.currentTimeMillis());
                }
                catch (IOException iOException) {}
            }
        }

        public void printTicks() {
            System.out.println("Packets " + this.ticks.size());
            long jitter = 0L;
            for (int i = 1; i < this.ticks.size(); ++i) {
                long diff = this.ticks.get(i) - this.ticks.get(i - 1);
                System.out.println("Server diff for index = " + i + " = " + diff);
                jitter += diff - 20L;
            }
            System.out.println("Jitter avg = " + jitter);
        }
    }

    private class Client1
    implements Runnable {
        private DatagramChannel channel;
        private ByteBuffer buffer = ByteBuffer.allocate(160);
        private ArrayList<Long> ticks = new ArrayList(5000);
        private InetSocketAddress destination;

        public Client1(int index) throws SocketException, IOException {
            int port = 8000 + index;
            InetSocketAddress address = new InetSocketAddress(mcAddress, port);
            this.destination = new InetSocketAddress(mcAddress, port - 2000);
            this.channel = DatagramChannel.open();
            this.channel.socket().bind(address);
            this.channel.connect(this.destination);
            this.channel.configureBlocking(false);
        }

        public void run() {
            int len = 160;
            byte[] buffer = new byte[len];
            try {
                for (int i = 0; i < len; ++i) {
                    buffer[i] = -90;
                }
                ByteBuffer buffer1 = ByteBuffer.wrap(buffer);
                for (int count = 0; count < len; count += count) {
                    count = this.channel.send(buffer1, this.destination);
                    if (count != 160) {
                        System.out.println("BAD!BAD!BAD! " + count);
                    }
                    buffer1.compact();
                    buffer1.flip();
                }
                this.ticks.add(System.currentTimeMillis());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void printTicks() {
            System.out.println("Packets " + this.ticks.size());
            for (int i = 1; i < this.ticks.size(); ++i) {
                System.out.println("Client diff for index = " + i + " =" + (this.ticks.get(i) - this.ticks.get(i - 1)));
            }
        }
    }

    private class Client
    implements Runnable {
        private DatagramSocket socket;
        private InetSocketAddress destination;
        private ArrayList<Long> ticks = new ArrayList(5000);

        public Client(int index) throws SocketException {
            int port = 8000 + index;
            InetSocketAddress address = new InetSocketAddress(mcAddress, port);
            this.destination = new InetSocketAddress(mcAddress, port - 2000);
            this.socket = new DatagramSocket(address);
        }

        public void run() {
            byte[] buffer = new byte[160];
            try {
                DatagramPacket p = new DatagramPacket(buffer, buffer.length, this.destination);
                for (int i = 0; i < 160; ++i) {
                    buffer[i] = -90;
                }
                this.socket.send(p);
                this.ticks.add(System.currentTimeMillis());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void printTicks() {
            System.out.println("Packets " + this.ticks.size());
            for (int i = 1; i < this.ticks.size(); ++i) {
                System.out.println("Client diff for index = " + i + " =" + (this.ticks.get(i) - this.ticks.get(i - 1)));
            }
        }
    }
}

