/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.rtp.sdp.FormatParser;
import org.mobicents.media.server.spi.rtp.AVProfile;

public class AudioFormatParser
implements FormatParser {
    public Format getFormat(int payload) {
        return AVPROFILE.getAudioFormat(payload);
    }

    public boolean parse(String rtpmap, int[] payloads, Format[] formats, int count) {
        int channels;
        int index;
        int pos = rtpmap.indexOf(58);
        int pos1 = rtpmap.indexOf(32, pos);
        int payload = Integer.parseInt(rtpmap.substring(pos + 1, pos1));
        for (index = 0; index < count && payloads[index] != payload; ++index) {
        }
        pos = rtpmap.indexOf(47, pos1);
        String encoding = rtpmap.substring(pos1 + 1, pos);
        pos1 = rtpmap.indexOf(47, pos + 1);
        double clockRate = pos1 > 0 ? Double.parseDouble(rtpmap.substring(pos + 1, pos1)) : Double.parseDouble(rtpmap.substring(pos + 1, rtpmap.length()));
        int n = channels = pos1 > 0 ? Integer.parseInt(rtpmap.substring(pos1 + 1, rtpmap.length())) : 1;
        if (encoding.equalsIgnoreCase("pcmu")) {
            formats[index] = new AudioFormat("ULAW", clockRate, 8, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("pcma")) {
            formats[index] = new AudioFormat("ALAW", clockRate, 8, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("speex")) {
            formats[index] = new AudioFormat("SPEEX", clockRate, -1, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("telephone-event")) {
            formats[index] = new AudioFormat("telephone-event", clockRate, -1, -1);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("g729")) {
            formats[index] = new AudioFormat("G729", clockRate, -1, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("gsm")) {
            formats[index] = new AudioFormat("GSM", clockRate, -1, channels);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("l16")) {
            formats[index] = new AudioFormat("LINEAR", clockRate, 16, channels, 0, 1);
            payloads[index] = payload;
        } else if (encoding.equalsIgnoreCase("AMR")) {
            formats[index] = new AudioFormat("AMR", clockRate, -1, channels);
            payloads[index] = payload;
        } else {
            formats[index] = new AudioFormat(encoding, clockRate, -1, channels);
            payloads[index] = payload;
        }
        return index == count;
    }

    public void write(StringBuffer buff, int p, Format f) {
        AudioFormat fmt = (AudioFormat)f;
        String encName = f.getEncoding().toLowerCase();
        buff.append("a=rtpmap:");
        buff.append(p);
        buff.append(" ");
        if (encName.equals("alaw")) {
            buff.append("pcma");
        } else if (encName.equals("ulaw")) {
            buff.append("pcmu");
        } else if (encName.equals("linear")) {
            buff.append("l" + fmt.getSampleSizeInBits());
        } else {
            buff.append(encName);
        }
        double sr = fmt.getSampleRate();
        if (sr > 0.0) {
            buff.append("/");
            if (sr - (double)((int)sr) < 1.0E-6) {
                buff.append((int)sr);
            } else {
                buff.append(sr);
            }
        }
        if (fmt.getChannels() > 1) {
            buff.append("/" + fmt.getChannels());
        }
        if (f.equals((Object)AVProfile.DTMF)) {
            buff.append("\na=fmtp:" + p + " 0-15");
        }
    }
}

