/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.mobicents.media.server.impl.rtp.sdp.Connection;
import org.mobicents.media.server.impl.rtp.sdp.MediaDescriptor;
import org.mobicents.media.server.impl.rtp.sdp.Origin;
import org.mobicents.media.server.spi.MediaType;

public class SessionDescriptor {
    private String version;
    private Origin origin;
    private String session;
    private Connection connection;
    private MediaDescriptor[] md = new MediaDescriptor[15];
    private int count;

    public SessionDescriptor(String sdp) {
        this(sdp, true);
    }

    public SessionDescriptor(String sdp, boolean processMandatoryFields) {
        BufferedReader reader = this.init(sdp);
        try {
            String line = reader.readLine();
            if (processMandatoryFields) {
                int pos = line.indexOf(61) + 1;
                this.version = line.substring(pos, line.length());
                line = reader.readLine();
                this.origin = new Origin(line);
                line = reader.readLine();
                pos = line.indexOf(61) + 1;
                this.session = line.substring(pos, line.length());
                line = this.next(reader);
            }
            block7: while (line != null) {
                char c = line.charAt(0);
                switch (c) {
                    case 'c': {
                        this.connection = new Connection(line);
                        break;
                    }
                    case 't': {
                        break;
                    }
                    case 'm': {
                        this.md[this.count++] = new MediaDescriptor(line);
                        line = this.parseAttributes(reader);
                        continue block7;
                    }
                }
                line = this.next(reader);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String parseAttributes(BufferedReader reader) throws IOException {
        String line = this.next(reader);
        while (line != null && !line.startsWith("m=")) {
            this.md[this.count - 1].parseAtribute(line);
            line = this.next(reader);
        }
        return line;
    }

    private String next(BufferedReader reader) throws IOException {
        return reader.readLine();
    }

    private BufferedReader init(String s) {
        return new BufferedReader(new StringReader(s));
    }

    public SessionDescriptor() {
        this.version = "0";
    }

    public String getVersion() {
        return this.version;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getMediaTypeCount() {
        return this.count;
    }

    public MediaDescriptor getMediaDescriptor(int i) {
        return this.md[i];
    }

    public MediaDescriptor getMediaDescriptor(MediaType mediaType) {
        for (int i = 0; i < this.count; ++i) {
            if (this.md[i].mediaType != mediaType) continue;
            return this.md[i];
        }
        return null;
    }

    public void createOrigin(String name, String sessionID, String sessionVersion, String networkType, String addressType, String address) {
        this.origin = new Origin(name, sessionID, sessionVersion, networkType, addressType, address);
    }

    public void createConnection(String networkType, String addressType, String address) {
        this.connection = new Connection(networkType, addressType, address);
    }

    public MediaDescriptor addMedia(MediaType mediaType, int port) {
        this.md[this.count++] = new MediaDescriptor(mediaType, port);
        return this.md[this.count - 1];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("v=" + this.version + "\n");
        buffer.append(this.origin.toString() + "\n");
        buffer.append("s=" + this.session + "\n");
        buffer.append(this.connection.toString() + "\n");
        buffer.append("t=0 0\n");
        for (int i = 0; i < this.count; ++i) {
            this.md[i].write(buffer);
        }
        return buffer.toString();
    }
}

