/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.util.StringPropertyReplacer;
import org.mobicents.media.server.bootstrap.MainDeployer;

public class Main {
    private static final String HOME_DIR = "MMS_HOME";
    private static final String BOOT_URL = "/conf/bootstrap-beans.xml";
    private static final String LOG4J_URL = "/conf/log4j.properties";
    public static final String MMS_HOME = "mms.home.dir";
    private static int index = 0;
    private Kernel kernel;
    private BasicXMLDeployer kernelDeployer;
    private Controller controller;
    private static Logger logger = Logger.getLogger(Main.class);

    public static void main(String[] args) throws Throwable {
        String homeDir = Main.getHomeDir(args);
        System.setProperty(MMS_HOME, homeDir);
        String Log4jURL = homeDir + LOG4J_URL;
        URL log4jurl = Main.getURL(Log4jURL);
        InputStream inStreamLog4j = log4jurl.openStream();
        Properties propertiesLog4j = new Properties();
        try {
            propertiesLog4j.load(inStreamLog4j);
            PropertyConfigurator.configure((Properties)propertiesLog4j);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info((Object)"log4j configured");
        URL bootURL = Main.getBootURL(args);
        Main main = new Main();
        logger.info((Object)("Booting from " + bootURL));
        System.out.println("Booting from " + bootURL);
        main.boot(bootURL);
        logger.info((Object)"Starting main deployer");
    }

    private static String getHomeDir(String[] args) {
        if (System.getenv(HOME_DIR) == null) {
            if (args.length > index) {
                return args[index++];
            }
            return ".";
        }
        return System.getenv(HOME_DIR);
    }

    private static URL getBootURL(String[] args) throws Exception {
        String bootURL = args.length > index ? args[index] : "${mms.home.dir}/conf/bootstrap-beans.xml";
        return Main.getURL(bootURL);
    }

    protected void boot(URL bootURL) throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.registerShutdownThread();
        this.kernel = bootstrap.getKernel();
        this.kernelDeployer = new BasicXMLDeployer(this.kernel);
        this.kernelDeployer.deploy(bootURL);
        this.kernelDeployer.validate();
        this.controller = this.kernel.getController();
        this.start(this.kernel, this.kernelDeployer);
    }

    public void start(Kernel kernel, BasicXMLDeployer kernelDeployer) {
        ControllerContext context = this.controller.getInstalledContext((Object)"MainDeployer");
        if (context != null) {
            MainDeployer deployer = (MainDeployer)context.getTarget();
            deployer.start(kernel, kernelDeployer);
        }
    }

    public static URL getURL(String url) throws Exception {
        File file = new File(url = StringPropertyReplacer.replaceProperties((String)url, (Properties)System.getProperties()));
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file: " + url);
        }
        return file.toURI().toURL();
    }

    protected void registerShutdownThread() {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownThread()));
    }

    private class ShutdownThread
    implements Runnable {
        private ShutdownThread() {
        }

        public void run() {
            System.out.println("Shutting down");
            Main.this.kernelDeployer.shutdown();
            Main.this.kernelDeployer = null;
            Main.this.kernel.getController().shutdown();
            Main.this.kernel = null;
        }
    }
}

