/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.mobicents.media.server.impl.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainDeployer {
    private Kernel kernel;
    private BasicXMLDeployer kernelDeployer;
    private int scanPeriod;
    private int initialDelay;
    private FileFilter fileFilter;
    private String path;
    private HashMap<URL, Long> deployments = new HashMap();
    private ScheduledExecutorService executor = null;
    private ScheduledFuture activeScan;
    private Logger logger = Logger.getLogger(MainDeployer.class);

    public MainDeployer() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ScannerThreadFactory());
    }

    public int getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(int scanPeriod) {
        this.scanPeriod = scanPeriod;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void start(Kernel kernel, BasicXMLDeployer kernelDeployer) {
        Version version = Version.instance;
        this.kernel = kernel;
        this.kernelDeployer = kernelDeployer;
        if (this.scanPeriod < 0) {
            this.scanPeriod = 0;
        }
        if (this.scanPeriod < 1000 && this.scanPeriod > 0) {
            this.scanPeriod = 1000;
        }
        if (this.scanPeriod != 0) {
            new HDScanner().run();
            this.activeScan = this.executor.scheduleAtFixedRate(new HDScanner(), this.scanPeriod, this.scanPeriod, TimeUnit.MILLISECONDS);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"scanPeriod is set to 0. Hot deployment disabled");
            }
            new HDScanner().run();
        }
        this.logger.info((Object)("[[[[[[[[[ " + version.toString() + " Started " + "]]]]]]]]]"));
    }

    public void stop() {
        if (this.activeScan != null) {
            this.activeScan.cancel(true);
        }
        this.logger.info((Object)"Stopped");
    }

    private void deploy(URL url) throws Throwable {
        this.kernelDeployer.deploy(url);
        this.kernelDeployer.validate();
    }

    private void undeploy(URL url) {
        this.kernelDeployer.undeploy(url);
    }

    private void redeploy(URL url) throws Throwable {
        this.undeploy(url);
        this.deploy(url);
    }

    private String getFilePath(File file) {
        return System.getProperty("mms.home.dir") + "/deploy/" + file.getName();
    }

    private Collection<URL> getNew(File[] files) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (File f : files) {
            try {
                URL url;
                if (!this.fileFilter.accept(f) || this.deployments.containsKey(url = f.toURI().toURL())) continue;
                this.deployments.put(url, f.lastModified());
                list.add(url);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return list;
    }

    private Collection<URL> getRemoved(File[] files) {
        ArrayList<URL> removed = new ArrayList<URL>();
        Set<URL> names = this.deployments.keySet();
        for (URL url : names) {
            boolean found = false;
            for (int i = 0; i < files.length; ++i) {
                try {
                    if (!url.equals(files[i].toURI().toURL())) continue;
                    found = true;
                    break;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (found) continue;
            removed.add(url);
        }
        for (URL url : removed) {
            this.deployments.remove(url);
        }
        return removed;
    }

    private Collection<URL> getUpdates(File[] files) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (File f : files) {
            try {
                long lastModified;
                URL name;
                if (!this.fileFilter.accept(f) || !this.deployments.containsKey(name = f.toURI().toURL()) || (lastModified = this.deployments.get(name).longValue()) >= f.lastModified()) continue;
                this.deployments.put(name, f.lastModified());
                list.add(name);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return list;
    }

    private class ScannerThreadFactory
    implements ThreadFactory {
        private ScannerThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "MMSDeployerScanner");
        }
    }

    private class HDScanner
    implements Runnable {
        private HDScanner() {
        }

        public void run() {
            File dir = new File(MainDeployer.this.path);
            File[] files = dir.listFiles();
            Collection list = MainDeployer.this.getNew(files);
            if (!list.isEmpty()) {
                for (URL fileName : list) {
                    MainDeployer.this.logger.info((Object)("Deploying " + fileName));
                    try {
                        MainDeployer.this.deploy(fileName);
                        MainDeployer.this.logger.info((Object)("Deployed " + fileName));
                    }
                    catch (Throwable t) {
                        MainDeployer.this.logger.error((Object)("Could not deploy " + fileName), t);
                    }
                }
            }
            if (!(list = MainDeployer.this.getRemoved(files)).isEmpty()) {
                for (URL fileName : list) {
                    MainDeployer.this.logger.info((Object)("Undeploying " + fileName));
                    try {
                        MainDeployer.this.undeploy(fileName);
                        MainDeployer.this.logger.info((Object)("Udeployed " + fileName));
                    }
                    catch (Throwable t) {
                        MainDeployer.this.logger.error((Object)("Could not undeploy " + fileName), t);
                    }
                }
            }
            if (!(list = MainDeployer.this.getUpdates(files)).isEmpty()) {
                for (URL fileName : list) {
                    MainDeployer.this.logger.info((Object)("Redeploying " + fileName));
                    try {
                        MainDeployer.this.redeploy(fileName);
                        MainDeployer.this.logger.info((Object)("Redeployed " + fileName));
                    }
                    catch (Throwable t) {
                        MainDeployer.this.logger.error((Object)("Could not redeploy " + fileName), t);
                    }
                }
            }
        }
    }
}

