/*
 * TrunkManagementMBean.java
 *
 * Mobicents Media Gateway
 *
 * The source code contained in this file is in in the public domain.
 * It can be used in any project or product without prior permission,
 * license or royalty payments. There is  NO WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR STATUTORY, INCLUDING, WITHOUT LIMITATION,
 * THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * AND DATA ACCURACY.  We do not warrant or make any representations
 * regarding the use of the software or the  results thereof, including
 * but not limited to the correctness, accuracy, reliability or
 * usefulness of the software.
 */

package org.mobicents.media.server.impl.jmx;

import javax.management.ObjectName;

import org.jboss.system.ServiceMBean;

/**
 *
 * @author Oleg Kulikov
 */
public interface TrunkManagementMBean extends ServiceMBean {
    /**
     * Gets ammount of Endpoints.
     *
     * @return the amount of endpoints included into this trunk.
     */
    public Integer getChannels();
    
    /**
     * Sets the amount of endpoints included into this trunk.
     *
     * @param channels the number of endpoints.
     */
    public void setChannels(Integer channels);
    
    public String getJndiName();
    
    public void setJndiName(String jndiName);
    
    public ObjectName getEndpointManagementMBean();
    
    public void setEndpointManagementMBean(ObjectName endpointMBean);    
    
    
}
