package org.mobicents.media.server.impl.events.announcement;

import java.io.File;

/**
 * This acts as Wrapper around File. Since AudioPlayer caches the remote files
 * (http://). It's necessary to delete the files once its not used for
 * scanDelay.
 * 
 * Setting flag delete to true will cause the File.delete() to be called from
 * FileCacheManager
 * 
 * @author amit bhayani
 * 
 */
public class FileCache {

	private boolean delete = false;
	private volatile long timestamp;
	private File file = null;

	public FileCache(File f, boolean delete) throws Exception {
		this.timestamp = System.currentTimeMillis();
		if (f == null) {
			throw new Exception("File cannot be null");
		}
		this.file = f;
		this.delete = delete;
	}

	public long getTimestamp() {
		return this.timestamp;
	}

	private void resetTimestamp() {
		this.timestamp = System.currentTimeMillis();
	}

	public boolean isDelete() {
		return delete;
	}

	public File getFile() {
		this.resetTimestamp();
		return file;
	}

}
