/*
 * AnnTrunkManagement.java
 *
 * Mobicents Media Gateway
 *
 * The source code contained in this file is in in the public domain.
 * It can be used in any project or product without prior permission,
 * license or royalty payments. There is  NO WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR STATUTORY, INCLUDING, WITHOUT LIMITATION,
 * THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * AND DATA ACCURACY.  We do not warrant or make any representations
 * regarding the use of the software or the  results thereof, including
 * but not limited to the correctness, accuracy, reliability or
 * usefulness of the software.
 */
package org.mobicents.media.server.impl.jmx.enp.ann;

import org.mobicents.media.server.impl.enp.ann.AnnEndpointImpl;
import org.mobicents.media.server.impl.events.announcement.FileCacheManager;
import org.mobicents.media.server.impl.jmx.TrunkManagement;
import org.mobicents.media.server.spi.Endpoint;

/**
 * 
 * @author Oleg Kulikov
 * @author amit bhayani
 */
public class AnnTrunkManagement extends TrunkManagement implements AnnTrunkManagementMBean {

	private long scanCacheDelay = 1000 * 60 * 5;
	private boolean cacheEnabled = true;

	/**
	 * Creates a new instance of AnnEndpointManagement
	 */
	public AnnTrunkManagement() {
	}

	@Override
	public Endpoint createEndpoint(String localName) throws Exception {
		AnnEndpointImpl endpoint = new AnnEndpointImpl(localName, this.cacheEnabled);
		return endpoint;
	}

	public long getCacheScanDelay() {
		return this.scanCacheDelay;
	}

	public void setCacheScanDelay(long scanCacheDelay) {
		if (scanCacheDelay > 60) {
			// Default set to 1 min
			this.scanCacheDelay = 1000 * 60 * 1;
		} else {
			this.scanCacheDelay = 1000 * scanCacheDelay;
		}
		this.scanCacheDelay = scanCacheDelay;

	}

	public boolean isCacheEnabled() {
		return this.cacheEnabled;
	}

	public void setCacheEnabled(boolean cacheEnabled) {
		this.cacheEnabled = cacheEnabled;
	}

	@Override
	public void startService() throws Exception {
		super.startService();
		if (this.cacheEnabled) {
			FileCacheManager bufferCacheManager = FileCacheManager.getInstance();
			bufferCacheManager.setScanDelay(this.getCacheScanDelay());
			try {
				bufferCacheManager.startCleanerProcess();
			} catch (Exception e) {
				// e.printStackTrace();
			}
		}

	}

}
