package org.mobicents.media.server.impl.jmx.enp.cnf;


import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.mobicents.media.server.impl.enp.cnf.ConfEndpointImpl;
import org.mobicents.media.server.impl.events.announcement.FileCacheManager;
import org.mobicents.media.server.impl.events.dtmf.DTMFMode;
import org.mobicents.media.server.impl.jmx.TrunkManagement;
import org.mobicents.media.server.spi.Endpoint;

public class ConfTrunkManagement extends TrunkManagement implements ConfTrunkManagementMBean {

    private String dtmfMode = "AUTO";
    private int maxConnections = 5;
    
	private long scanCacheDelay = 1000 * 60 * 5;
	private boolean cacheEnabled = true;
    
    @Override
    public Endpoint createEndpoint(String name) throws Exception {
    	ConfEndpointImpl endpoint = new ConfEndpointImpl(name, this.cacheEnabled);
        endpoint.setDtmfMode(DTMFMode.valueOf(dtmfMode));
        endpoint.setMaxConnectionsAvailable(this.maxConnections);
        return endpoint;
    }

    public void makeEndpoint() {
    }
    
    
    public String getDtmfMode() {
        return dtmfMode;
    }

    public void setDtmfMode(String mode) throws NamingException {
        this.dtmfMode = mode;        
        if (this.getState() == STARTED) {
            InitialContext ic = new InitialContext();
            for (int i = 0; i < this.getChannels(); i++) {
            	ConfEndpointImpl endpoint = (ConfEndpointImpl) ic.lookup(this.getJndiName() +"/" + i);
                endpoint.setDtmfMode(DTMFMode.valueOf(dtmfMode));
            }
        }        
    }
    
    public int getMaxConnections(){
    	return this.maxConnections;
    }
    public void setMaxConnections(int maxConnections){
    	this.maxConnections = maxConnections;
    }

	public long getCacheScanDelay() {
		return this.scanCacheDelay;
	}

	public void setCacheScanDelay(long scanCacheDelay) {
		if (scanCacheDelay > 60) {
			// Default set to 1 min
			this.scanCacheDelay = 1000 * 60 * 1;
		} else {
			this.scanCacheDelay = 1000 * scanCacheDelay;
		}
		this.scanCacheDelay = scanCacheDelay;

	}

	public boolean isCacheEnabled() {
		return this.cacheEnabled;
	}

	public void setCacheEnabled(boolean cacheEnabled) {
		this.cacheEnabled = cacheEnabled;
	}
	
	@Override
	public void startService() throws Exception {
		super.startService();
		if (this.cacheEnabled) {
			FileCacheManager bufferCacheManager = FileCacheManager.getInstance();
			bufferCacheManager.setScanDelay(this.getCacheScanDelay());
			try {
				bufferCacheManager.startCleanerProcess();
			} catch (Exception e) {
				// e.printStackTrace();
			}
		}

	}	
}
