/*
 * PRTrunkManagement.java
 *
 * Mobicents Media Gateway
 *
 * The source code contained in this file is in in the public domain.
 * It can be used in any project or product without prior permission,
 * license or royalty payments. There is  NO WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR STATUTORY, INCLUDING, WITHOUT LIMITATION,
 * THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * AND DATA ACCURACY.  We do not warrant or make any representations
 * regarding the use of the software or the  results thereof, including
 * but not limited to the correctness, accuracy, reliability or
 * usefulness of the software.
 */
package org.mobicents.media.server.impl.jmx.enp.prl;


import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.mobicents.media.server.impl.enp.prl.PREndpointImpl;
import org.mobicents.media.server.impl.events.dtmf.DTMFMode;
import org.mobicents.media.server.impl.jmx.EndpointManagementMBean;
import org.mobicents.media.server.impl.jmx.TrunkManagement;
import org.mobicents.media.server.spi.Endpoint;

/**
 * 
 * @author Oleg Kulikov
 */
public class PRTrunkManagement extends TrunkManagement implements PRTrunkManagementMBean {
	
    private String dtmfMode = "AUTO";

    /** Creates a new instance of PREndpointManagement */
    public Endpoint createEndpoint(String name) throws Exception {
        PREndpointImpl endpoint =  new PREndpointImpl(name);
        endpoint.setDtmfMode(DTMFMode.valueOf(dtmfMode));
        return endpoint;
    }

    public EndpointManagementMBean cloneEndpointManagementMBean() {
        PREndpointManagement clone = new PREndpointManagement();
        return clone;
    }
    
    public String getDtmfMode() {
        return dtmfMode;
    }

    public void setDtmfMode(String mode) throws NamingException {
        this.dtmfMode = mode;
        if (this.getState() == STARTED) {
            InitialContext ic = new InitialContext();
            for (int i = 0; i < this.getChannels(); i++) {
            	PREndpointImpl endpoint = (PREndpointImpl) ic.lookup(this.getJndiName() +"/" + i);
                endpoint.setDtmfMode(DTMFMode.valueOf(dtmfMode));
            }
        }        
    }
}
