/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.data;

import java.io.Serializable;

public class Notifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String param;
    private final boolean presList;
    private final boolean pocGroup;
    private transient String uriWithParam = null;
    private static final String COLON = ";";
    private static final String PRES_LIST = "pres-list=";
    private static final String POC_GROUP = "poc-group=";

    public Notifier(String notifier) {
        String[] notifierParts = notifier.split(COLON);
        if (notifierParts.length > 1) {
            this.uri = notifierParts[0];
            for (int i = 1; i < notifierParts.length; ++i) {
                if (notifierParts[i].startsWith(PRES_LIST)) {
                    this.param = notifierParts[i];
                    this.presList = true;
                    this.pocGroup = false;
                    return;
                }
                if (!notifierParts[i].startsWith(POC_GROUP)) continue;
                this.param = notifierParts[i];
                this.presList = false;
                this.pocGroup = true;
                return;
            }
            this.param = null;
        } else {
            this.uri = notifier;
            this.param = null;
        }
        this.presList = false;
        this.pocGroup = false;
    }

    public String getUri() {
        return this.uri;
    }

    public String getParam() {
        return this.param;
    }

    public String getUriWithParam() {
        if (this.uriWithParam == null) {
            this.uriWithParam = this.param == null ? this.uri : this.uri + COLON + this.param;
        }
        return this.uriWithParam;
    }

    public boolean isPocGroup() {
        return this.pocGroup;
    }

    public boolean isPresList() {
        return this.presList;
    }

    public String toString() {
        return this.getUriWithParam();
    }
}

