/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.pojo;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.slee.facilities.TimerID;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;

@Entity
@Table(name="MOBICENTS_SIPEVENT_SUBSCRIPTIONS")
@NamedQueries(value={@NamedQuery(name="selectSubscriptionFromTimerID", query="SELECT s FROM Subscription s WHERE s.timerID = :timerID"), @NamedQuery(name="selectSubscriptionsFromNotifierAndEventPackage", query="SELECT s FROM Subscription s WHERE s.notifier = :notifier AND s.key.eventPackage = :eventPackage"), @NamedQuery(name="selectDialogSubscriptions", query="SELECT s FROM Subscription s WHERE s.key.callId = :callId AND s.key.remoteTag = :remoteTag")})
public class Subscription
implements Serializable {
    private static final long serialVersionUID = 8020033417766370446L;
    @EmbeddedId
    protected SubscriptionKey key;
    @Column(name="SUBSCRIBER", nullable=false)
    private String subscriber;
    @Column(name="NOTIFER", nullable=false)
    private String notifier;
    @Column(name="STATUS", nullable=false)
    private Status status;
    @Column(name="CREATION_DATE", nullable=false)
    private long creationDate;
    @Column(name="LAST_REFRESH_DATE", nullable=false)
    private long lastRefreshDate;
    @Column(name="EXPIRES", nullable=false)
    private int expires;
    @Column(name="SUBSCRIBER_DISPLAY_NAME", nullable=true)
    private String subscriberDisplayName;
    @Column(name="LAST_EVENT", nullable=true)
    private Event lastEvent;
    @Column(name="TIMER_ID", nullable=true)
    private TimerID timerID;
    @Column(name="VERSION", nullable=false)
    private int version;

    public Subscription() {
    }

    public Subscription(SubscriptionKey key, String subscriber, String notifier, Status status, String subscriberDisplayName, int expires) {
        this.key = key;
        this.subscriber = subscriber;
        this.notifier = notifier;
        this.status = status;
        if (status.equals((Object)Status.active)) {
            this.lastEvent = Event.approved;
        } else if (status.equals((Object)Status.pending)) {
            this.lastEvent = Event.subscribe;
        }
        this.lastRefreshDate = this.creationDate = System.currentTimeMillis();
        this.expires = expires;
        this.subscriberDisplayName = subscriberDisplayName;
        this.version = 0;
    }

    public int getRemainingExpires() {
        long remainingExpires = (long)this.expires - (System.currentTimeMillis() - this.lastRefreshDate) / 1000L;
        if (this.expires < 0) {
            return 0;
        }
        return (int)remainingExpires;
    }

    public int getSubscriptionDuration() {
        return (int)((System.currentTimeMillis() - this.creationDate) / 1000L);
    }

    public void refresh(int expires) {
        this.lastRefreshDate = System.currentTimeMillis();
        this.expires = expires;
    }

    public boolean changeStatus(Event event) {
        Status oldStatus = this.status;
        if (this.status == Status.active) {
            if (event == Event.noresource || event == Event.rejected || event == Event.deactivated || event == Event.probation || event == Event.timeout) {
                this.status = Status.terminated;
            }
        } else if (this.status == Status.pending) {
            if (event == Event.approved) {
                this.status = Status.active;
            } else if (event == Event.timeout) {
                this.status = Status.waiting;
            } else if (event == Event.noresource || event == Event.rejected || event == Event.deactivated || event == Event.probation || event == Event.giveup) {
                this.status = Status.terminated;
            }
        } else if (this.status == Status.waiting && (event == Event.noresource || event == Event.rejected || event == Event.giveup || event == Event.approved)) {
            this.status = Status.terminated;
        }
        if (this.status != oldStatus) {
            this.lastEvent = event;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((Subscription)obj).key.equals(this.key);
        }
        return false;
    }

    public SubscriptionKey getKey() {
        return this.key;
    }

    public void setKey(SubscriptionKey key) {
        this.key = key;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public String getNotifier() {
        return this.notifier;
    }

    public void setNotifier(String notifier) {
        this.notifier = notifier;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastRefreshDate() {
        return this.lastRefreshDate;
    }

    public void setLastRefreshDate(long lastRefreshDate) {
        this.lastRefreshDate = lastRefreshDate;
    }

    public int getExpires() {
        return this.expires;
    }

    public void setExpires(int expires) {
        this.expires = expires;
    }

    public String getSubscriberDisplayName() {
        return this.subscriberDisplayName;
    }

    public void setSubscriberDisplayName(String subscriberDisplayName) {
        this.subscriberDisplayName = subscriberDisplayName;
    }

    public Event getLastEvent() {
        return this.lastEvent;
    }

    public void setLastEvent(Event lastEvent) {
        this.lastEvent = lastEvent;
    }

    public TimerID getTimerID() {
        return this.timerID;
    }

    public void setTimerID(TimerID timerID) {
        this.timerID = timerID;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void incrementVersion() {
        ++this.version;
    }

    public String toString() {
        return "subscription: subscriber=" + this.subscriber + ",notifier=" + this.notifier + ",eventPackage=" + this.key.getEventPackage() + ",eventId=" + this.key.getRealEventId() + ",status=" + (Object)((Object)this.status);
    }

    public static Subscription getSubscription(EntityManager entityManager, String callId, String remoteTag, String eventPackage, String eventId) {
        return (Subscription)entityManager.find(Subscription.class, (Object)new SubscriptionKey(callId, remoteTag, eventPackage, eventId));
    }

    public static List getDialogSubscriptions(EntityManager entityManager, String callId, String remoteTag) {
        return entityManager.createNamedQuery("selectDialogSubscriptions").setParameter("callId", (Object)callId).setParameter("remoteTag", (Object)remoteTag).getResultList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        noresource,
        rejected,
        deactivated,
        probation,
        timeout,
        approved,
        giveup,
        subscribe;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        active,
        pending,
        waiting,
        terminated;

    }
}

