/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.enabler.userprofile.jpa.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.mobicents.slee.enabler.userprofile.jpa.UserProfile;
import org.mobicents.slee.enabler.userprofile.jpa.jmx.UserProfileControlManagementMBean;

public class UserProfileControlManagement
implements UserProfileControlManagementMBean {
    private static final Logger logger = Logger.getLogger(UserProfileControlManagement.class);
    private TransactionManager txMgr;
    private EntityManagerFactory entityManagerFactory;
    private static final UserProfileControlManagement INSTANCE = new UserProfileControlManagement();

    public static UserProfileControlManagement getInstance() {
        return INSTANCE;
    }

    private UserProfileControlManagement() {
    }

    public void start() {
        try {
            this.txMgr = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"mobicents-slee-enabler-userprofile-pu");
        logger.info((Object)"Service started.");
    }

    public void stop() {
        this.entityManagerFactory.close();
        logger.info((Object)"Service stopped.");
    }

    public void addUser(String username, String password) throws NullPointerException, IllegalStateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addUser( username = " + username + ")"));
        }
        if (username == null) {
            throw new NullPointerException("null username");
        }
        if (this.getUser(username) != null) {
            throw new IllegalStateException("user " + username + " already exists");
        }
        EntityManager entityManager = null;
        Transaction tx = null;
        try {
            if (this.txMgr.getTransaction() != null) {
                tx = this.txMgr.suspend();
            }
            this.txMgr.begin();
            entityManager = this.entityManagerFactory.createEntityManager();
            UserProfile userProfile = new UserProfile(username);
            userProfile.setPassword(password);
            entityManager.persist((Object)userProfile);
            this.txMgr.commit();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Added user " + username));
            }
        }
        catch (Throwable e) {
            try {
                this.txMgr.rollback();
            }
            catch (Throwable f) {
                logger.error((Object)f.getMessage(), f);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (tx != null) {
                try {
                    this.txMgr.resume(tx);
                }
                catch (Throwable f) {
                    logger.error((Object)f.getMessage(), f);
                }
            }
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listUsers() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"listUsers()");
        }
        EntityManager entityManager = null;
        try {
            entityManager = this.entityManagerFactory.createEntityManager();
            ArrayList<String> resultList = new ArrayList<String>();
            for (Object result : entityManager.createNamedQuery("MSPS_UP_NQUERY_selectAllUserProfiles").getResultList()) {
                UserProfile userProfile = (UserProfile)result;
                resultList.add(userProfile.getUsername());
            }
            String[] resultArray = new String[resultList.size()];
            String[] stringArray = resultList.toArray(resultArray);
            return stringArray;
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    public String listUsersAsString() {
        return Arrays.asList(this.listUsers()).toString();
    }

    public boolean removeUser(String username) throws NullPointerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeUser( username = " + username + " )"));
        }
        if (username == null) {
            throw new NullPointerException("null username");
        }
        EntityManager entityManager = null;
        Transaction tx = null;
        try {
            boolean exists;
            if (this.txMgr.getTransaction() != null) {
                tx = this.txMgr.suspend();
            }
            this.txMgr.begin();
            entityManager = this.entityManagerFactory.createEntityManager();
            UserProfile userProfile = (UserProfile)entityManager.find(UserProfile.class, (Object)username);
            boolean bl = exists = userProfile != null;
            if (exists) {
                entityManager.remove((Object)userProfile);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Removed user " + username));
                }
            }
            this.txMgr.commit();
            boolean bl2 = exists;
            return bl2;
        }
        catch (Throwable e) {
            try {
                this.txMgr.rollback();
            }
            catch (Throwable f) {
                logger.error((Object)f.getMessage(), f);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (tx != null) {
                try {
                    this.txMgr.resume(tx);
                }
                catch (Throwable f) {
                    logger.error((Object)f.getMessage(), f);
                }
            }
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    public UserProfile getUser(String username) throws NullPointerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getUser( username = " + username + " )"));
        }
        if (username == null) {
            throw new NullPointerException("null username");
        }
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        UserProfile userProfile = (UserProfile)entityManager.find(UserProfile.class, (Object)username);
        entityManager.close();
        return userProfile;
    }
}

