/*
 * RtpTrafficDialog.java
 *
 * Created on 4 Декабрь 2008 г., 10:33
 */
package org.mobicents.media.server.testsuite.gui.graph;

import java.io.IOException;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;

/**
 *
 * @author  kulikov
 */
public class RtpTrafficGraph extends javax.swing.JDialog {

    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;
    private AbstractCall call;

    /** Creates new form RtpTrafficDialog */
    public RtpTrafficGraph(java.awt.Frame parent, boolean modal, AbstractCall call) throws IOException {
        super(parent, modal);
        this.call = call;
        initComponents();
        
        List<RtpPacket> packets = call.getRtp();

        XYSeries j = new XYSeries("Jitter");
        for (int i = 0; i < packets.size() - 1; i++) {
            RtpPacket p1 = packets.get(i);
            RtpPacket p2 = packets.get(i +  1);

            j.add(i, p2.getTime().getTime() - p1.getTime().getTime());
        }

        XYDataset dataset = new XYSeriesCollection(j);
        JFreeChart chart = ChartFactory.createXYLineChart("Jitter chart", // Title
                "Jitter", // X-Axis label
                "Time", // Y-Axis label
                dataset, // Dataset
                PlotOrientation.VERTICAL,
                true, true, true // Show legend
                );
        org.jfree.chart.ChartPanel chartPanel = new ChartPanel(chart);
        desktop.removeAll();
        desktop.add(chartPanel, java.awt.BorderLayout.CENTER);
    }

    private void printErrors(int[] errors, int count) {
        for (int i = 0; i < count; i++) {
            System.out.println(errors[i]);
        }
    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();
        desktop = new javax.swing.JPanel();

        setTitle("RTP Traffic");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        jPanel1.add(closeButton);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        desktop.setLayout(new java.awt.BorderLayout());
        getContentPane().add(desktop, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog

private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
    doClose(RET_OK);
}//GEN-LAST:event_closeButtonActionPerformed

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JPanel desktop;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
