/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sdp.Attribute;
import javax.sdp.SdpFactory;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.CallDisplayInterface;
import org.mobicents.media.server.testsuite.general.CallState;
import org.mobicents.media.server.testsuite.general.file.FileUtils;
import org.mobicents.media.server.testsuite.gui.ext.CallStateTableModel;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
implements JainMgcpExtendedListener,
Runnable,
Serializable {
    protected transient Logger logger = Logger.getLogger(this.getClass().getName());
    private TestState testState = TestState.Stoped;
    public static final transient String _CASE_FILE = "testcase.bin";
    protected transient SdpFactory sdpFactory;
    protected transient CallDisplayInterface callDisplay;
    protected Map<Long, AbstractCall> callSequenceToCall;
    protected transient CallStateTableModel model;
    protected InetAddress clientTestNodeAddress;
    protected InetAddress serverJbossBindAddress;
    protected transient JainMgcpStackImpl stack;
    protected transient JainMgcpStackProviderImpl provider;
    protected transient Map<Integer, AbstractCall> mgcpTransactionToProxy = new HashMap<Integer, AbstractCall>();
    protected transient Map<String, AbstractCall> requestIdIdToProxy = new HashMap<String, AbstractCall>();
    protected long testTimesTamp = System.currentTimeMillis();
    protected transient File testDumpDirectory;
    protected final transient ScheduledExecutorService callCreator = Executors.newSingleThreadScheduledExecutor();
    protected transient ScheduledFuture callCreatorTask;
    protected final transient ScheduledExecutorService timeGuard = Executors.newScheduledThreadPool(5);
    protected int ongoingCallNumber;
    protected int errorCallNumber;
    protected int completedCallNumber;
    protected int totalCalls;

    public AbstractTestCase() {
        this.callSequenceToCall = new HashMap<Long, AbstractCall>();
    }

    public AbstractTestCase(CallDisplayInterface cdi) throws UnknownHostException, IllegalStateException {
        this.setCallDisplay(cdi);
        this.model = new CallStateTableModel(this.callSequenceToCall);
    }

    protected void incrementOngoignCall() {
        ++this.ongoingCallNumber;
        ++this.totalCalls;
    }

    protected void decrementOngoingCall() {
        --this.ongoingCallNumber;
    }

    protected void incrementErrorCall() {
        ++this.errorCallNumber;
    }

    protected void incrementCompletedCall() {
        ++this.completedCallNumber;
    }

    public long getTestTimeStamp() {
        return this.testTimesTamp;
    }

    public InetAddress getClientTestNodeAddress() {
        return this.clientTestNodeAddress;
    }

    public InetAddress getServerJbossBindAddress() {
        return this.serverJbossBindAddress;
    }

    public CallDisplayInterface getCallDisplayInterface() {
        return this.callDisplay;
    }

    public AbstractCall getCallBySequence(Long seq) {
        return this.callSequenceToCall.get(seq);
    }

    public void callStateChanged(AbstractCall c) {
        CallState callState = c.getState();
        if (callState == CallState.INITIAL) {
            this.incrementOngoignCall();
        } else if (callState == CallState.ENDED) {
            this.decrementOngoingCall();
            this.incrementCompletedCall();
        } else if (callState == CallState.IN_ERROR) {
            this.decrementOngoingCall();
            this.incrementErrorCall();
        }
        this.callDisplay.updateCallView();
        if (this.testState == TestState.Terminating && this.getOngoingCallNumber() == 0) {
            this.stop();
        }
    }

    public CallStateTableModel getTableModel() {
        return this.model;
    }

    public int getCompletedCallNumber() {
        return this.completedCallNumber;
    }

    public int getErrorCallNumber() {
        return this.errorCallNumber;
    }

    public int getOngoingCallNumber() {
        return this.ongoingCallNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        switch (this.testState) {
            case Terminating: {
                try {
                    if (this.provider != null) {
                        try {
                            this.provider.removeJainMgcpListener((JainMgcpListener)this);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.stack != null) {
                        try {
                            this.stack.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.callCreatorTask != null) {
                        this.callCreatorTask.cancel(true);
                    }
                    try {
                        for (AbstractCall call : this.callSequenceToCall.values()) {
                            if (call.getState() != CallState.ESTABILISHED && call.getState() != CallState.INITIAL) continue;
                            call.stop();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.serialize();
                    Object var4_6 = null;
                    this.testState = TestState.Stoped;
                    break;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    this.testState = TestState.Stoped;
                    throw throwable;
                }
            }
            case Running: {
                this.testState = TestState.Terminating;
            }
        }
    }

    public void start() throws CreateProviderException, TooManyListenersException {
        try {
            this.stop();
            this.clientTestNodeAddress = InetAddress.getByName(this.callDisplay.getLocalAddress());
            this.serverJbossBindAddress = InetAddress.getByName(this.callDisplay.getRemoteAddress());
            this.stack = new JainMgcpStackImpl(this.clientTestNodeAddress, this.callDisplay.getLocalPort());
            this.provider = (JainMgcpStackProviderImpl)this.stack.createProvider();
            this.provider.addJainMgcpListener((JainMgcpListener)this);
            this.testState = TestState.Running;
            this.onCPSChange();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(AbstractTestCase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCallDisplay(CallDisplayInterface cdi) throws UnknownHostException, IllegalStateException {
        this.callDisplay = cdi;
        this.clientTestNodeAddress = InetAddress.getByName(this.callDisplay.getRemoteAddress());
        this.serverJbossBindAddress = InetAddress.getByName(this.callDisplay.getRemoteAddress());
        this.sdpFactory = SdpFactory.getInstance();
        this.testDumpDirectory = new File(cdi.getDefaultDataDumpDirectory(), "" + this.testTimesTamp);
        if (!this.testDumpDirectory.exists()) {
            if (!this.testDumpDirectory.mkdirs()) {
                throw new IllegalStateException("Failed to create dirs: " + this.testDumpDirectory);
            }
        } else if (!this.testDumpDirectory.isDirectory() || !this.testDumpDirectory.canWrite()) {
            throw new IllegalStateException("Failed to validate dump dir, its either not writeable or is not a directory: " + this.testDumpDirectory);
        }
    }

    public void setCallDisplay(CallDisplayInterface cdi, File testDumpDirectory) throws UnknownHostException, IllegalStateException {
        this.callDisplay = cdi;
        this.sdpFactory = SdpFactory.getInstance();
        this.testDumpDirectory = testDumpDirectory;
        this.model = new CallStateTableModel(this.callSequenceToCall);
        for (AbstractCall call : this.callSequenceToCall.values()) {
            call.setDumpDir(testDumpDirectory);
        }
    }

    public void onCPSChange() {
        int cps;
        if (this.testState == TestState.Stoped) {
            return;
        }
        if (this.callCreatorTask != null) {
            this.callCreatorTask.cancel(true);
        }
        if ((cps = this.getCallDisplayInterface().getCPS()) == 0) {
            return;
        }
        int delta = 1000 / this.getCallDisplayInterface().getCPS();
        this.callCreatorTask = this.callCreator.scheduleAtFixedRate(this, delta, delta, TimeUnit.MILLISECONDS);
    }

    public void onCallLengthChange() {
    }

    public abstract AbstractCall getNewCall();

    Vector<Attribute> getSDPAttributes() {
        return this.callDisplay.getCodec();
    }

    public SdpFactory getSdpFactory() {
        return this.sdpFactory;
    }

    public File getTestDumpDirectory() {
        return this.testDumpDirectory;
    }

    @Override
    public void run() {
        if (this.testState == TestState.Running) {
            try {
                AbstractCall c = this.getNewCall();
                this.callSequenceToCall.put(c.getSequence(), c);
                this.callStateChanged(c);
                c.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JainMgcpStackProviderImpl getProvider() {
        return this.provider;
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
        Notify notify;
        AbstractCall cp;
        if (command instanceof Notify && (cp = this.getCall((notify = (Notify)command).getRequestIdentifier().toString())) != null) {
            cp.processMgcpCommandEvent(command);
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent response) {
        try {
            AbstractCall cp = this.getCall((JainMgcpEvent)response);
            if (cp != null) {
                cp.processMgcpResponseEvent(response);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public void transactionEnded(int arg0) {
        AbstractCall cp = this.getCall(arg0);
        if (cp != null) {
            cp.transactionEnded(arg0);
        } else {
            this.logger.severe("No call proxy for txid: " + arg0);
        }
    }

    public void transactionRxTimedOut(JainMgcpCommandEvent commandTimedOut) {
        AbstractCall cp = this.getCall((JainMgcpEvent)commandTimedOut);
        if (cp != null) {
            cp.transactionRxTimedOut(commandTimedOut);
        } else {
            this.logger.severe("No call proxy for txid: " + commandTimedOut.getTransactionHandle() + " for timed out event");
        }
    }

    public void transactionTxTimedOut(JainMgcpCommandEvent commandTimeOut) {
        AbstractCall cp = this.getCall((JainMgcpEvent)commandTimeOut);
        if (cp != null) {
            cp.transactionTxTimedOut(commandTimeOut);
        } else {
            this.logger.severe("No call proxy for txid: " + commandTimeOut.getTransactionHandle() + " for timed out event2");
        }
    }

    protected AbstractCall getCall(JainMgcpEvent mgcpEvent) {
        return this.mgcpTransactionToProxy.get(mgcpEvent.getTransactionHandle());
    }

    protected AbstractCall getCall(int txID) {
        return this.mgcpTransactionToProxy.get(txID);
    }

    public void removeCall(JainMgcpEvent mgcpEvent) {
        this.removeCall(mgcpEvent.getTransactionHandle());
    }

    public void removeCall(int txID) {
        this.mgcpTransactionToProxy.remove(txID);
    }

    public void addCall(String ri, AbstractCall cp) {
        this.requestIdIdToProxy.put(ri, cp);
    }

    public void removeCall(String ri) {
        this.requestIdIdToProxy.remove(ri);
    }

    public AbstractCall getCall(String ri) {
        return this.requestIdIdToProxy.get(ri);
    }

    public void addCall(JainMgcpEvent mgcpEvent, AbstractCall cp) {
        this.mgcpTransactionToProxy.put(mgcpEvent.getTransactionHandle(), cp);
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
    }

    protected void serialize() {
        FileUtils.serializeTestCase(this);
    }

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.defaultWriteObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TestState {
        Stoped,
        Terminating,
        Running;

    }
}

