/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general.rtp;

import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;

public class PacketTableModel
extends DefaultTableModel {
    private SimpleDateFormat fmt = new SimpleDateFormat("mm:ss,SSS");
    private String[] columnNames = new String[]{"Time", "Seq number", "SSRC", "Timestamp", "Payload"};
    private List<RtpPacket> packets;

    public PacketTableModel(List packets) {
        this.packets = packets;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        int count = this.packets != null ? this.packets.size() : 0;
        return count;
    }

    private String getFormat(int pt) {
        if (pt == 8) {
            return "PCMA";
        }
        if (pt == 0) {
            return "PCMU";
        }
        return "UNKNOWN";
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        RtpPacket packet = this.packets.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.fmt.format(packet.getTime());
            }
            case 1: {
                return packet.getSeqNumber();
            }
            case 2: {
                return packet.getSSRC();
            }
            case 3: {
                return packet.getTimestamp();
            }
            case 4: {
                return this.getFormat(packet.getPayloadType());
            }
        }
        return null;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }
}

